/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.restful.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.configuration.entity.DepartmentTenantVo;
import org.apache.linkis.configuration.entity.TenantVo;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.TenantConfigService;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping(path={"/configuration/tenant-mapping"})
public class TenantConfigrationRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(TenantConfigrationRestfulApi.class);
    @Autowired
    private TenantConfigService tenantConfigService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="body", dataType="TenantVo", name="tenantVo", value="tenantVo")})
    @ApiOperation(value="create-tenant", notes="create tenant", httpMethod="POST", response=Message.class)
    @RequestMapping(path={"/create-tenant"}, method={RequestMethod.POST})
    public Message createTenant(HttpServletRequest req, @RequestBody TenantVo tenantVo) {
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"execute createTenant");
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to create-tenant,msg: only administrators can configure");
            }
            this.parameterVerification(tenantVo);
            if (this.tenantConfigService.isExist(tenantVo.getUser(), tenantVo.getCreator()).booleanValue()) {
                throw new ConfigurationException("User-creator is existed");
            }
            this.tenantConfigService.createTenant(tenantVo);
        }
        catch (DuplicateKeyException e) {
            return Message.error((String)"Failed to create-tenant,msg:create user-creator is existed");
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to create-tenant,msg:" + e.getMessage()));
        }
        return Message.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="body", dataType="TenantVo", name="tenantVo", value="tenantVo")})
    @ApiOperation(value="update-tenant", notes="update tenant", httpMethod="POST", response=Message.class)
    @RequestMapping(path={"/update-tenant"}, method={RequestMethod.POST})
    public Message updateTenant(HttpServletRequest req, @RequestBody TenantVo tenantVo) {
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"execute updateTenant");
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to update-tenant,msg: only administrators can configure");
            }
            this.parameterVerification(tenantVo);
            this.tenantConfigService.updateTenant(tenantVo);
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to update-tenant,msg:" + e.getMessage()));
        }
        return Message.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="query", dataType="int", name="id", value="id")})
    @ApiOperation(value="delete-tenant", notes="delete tenant", httpMethod="GET", response=Message.class)
    @RequestMapping(path={"/delete-tenant"}, method={RequestMethod.GET})
    public Message deleteTenant(HttpServletRequest req, @RequestParam(value="id") Integer id) {
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("execute deleteTenant,id: " + id));
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to delete-tenant,msg: only administrators can configure");
            }
            this.tenantConfigService.deleteTenant(id);
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to delete-tenant,msg:" + e.getMessage()));
        }
        return Message.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="query", dataType="string", name="user", value="user"), @ApiImplicitParam(paramType="query", dataType="string", name="creator", value="creator"), @ApiImplicitParam(paramType="query", dataType="string", name="tenantValue", value="tenantValue")})
    @ApiOperation(value="query-tenant-list", notes="query tenant list", httpMethod="GET", response=Message.class)
    @RequestMapping(path={"/query-tenant-list"}, method={RequestMethod.GET})
    public Message queryTenantList(HttpServletRequest req, @RequestParam(value="user", required=false) String user, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="tenantValue", required=false) String tenantValue, @RequestParam(value="pageNow", required=false) Integer pageNow, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"execute queryTenantList");
        if (!Configuration.isAdmin((String)userName)) {
            return Message.error((String)"Failed to query-tenant-list,msg: only administrators can configure");
        }
        if (StringUtils.isBlank((String)user)) {
            user = null;
        }
        if (StringUtils.isBlank((String)creator)) {
            creator = null;
        }
        if (StringUtils.isBlank((String)tenantValue)) {
            tenantValue = null;
        }
        if (null == pageNow) {
            pageNow = 1;
        }
        if (null == pageSize) {
            pageSize = 20;
        }
        Map<String, Object> resultMap = this.tenantConfigService.queryTenantList(user, creator, tenantValue, pageNow, pageSize);
        return Message.ok().data("tenantList", resultMap.get("tenantList")).data(JobRequestConstants.TOTAL_PAGE(), resultMap.get(JobRequestConstants.TOTAL_PAGE()));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="query", dataType="string", name="user", value="user"), @ApiImplicitParam(paramType="query", dataType="string", name="creator", value="creator"), @ApiImplicitParam(paramType="query", dataType="string", name="tenantValue", value="tenantValue")})
    @ApiOperation(value="check-user-creator", notes="check user creator", httpMethod="GET", response=Message.class)
    @RequestMapping(path={"/check-user-creator"}, method={RequestMethod.GET})
    public Message checkUserCreator(HttpServletRequest req, @RequestParam(value="user", required=false) String user, @RequestParam(value="creator", required=false) String creator) {
        Boolean result = false;
        try {
            if (StringUtils.isBlank((String)creator)) {
                throw new ConfigurationException("Application Name can't be empty ");
            }
            if (StringUtils.isBlank((String)user)) {
                throw new ConfigurationException("User Name can't be empty ");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"checkUserCreator");
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to check-user-creator,msg: only administrators can configure");
            }
            result = this.tenantConfigService.isExist(user, creator);
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to check-user-creator,msg:" + e.getMessage()));
        }
        return Message.ok().data("exist", (Object)result);
    }

    private void parameterVerification(TenantVo tenantVo) throws ConfigurationException {
        if (StringUtils.isBlank((String)tenantVo.getCreator())) {
            throw new ConfigurationException("Application name can't be empty ");
        }
        if (StringUtils.isBlank((String)tenantVo.getUser())) {
            throw new ConfigurationException("User name can't be empty ");
        }
        if (StringUtils.isBlank((String)tenantVo.getBussinessUser())) {
            throw new ConfigurationException("Creat user can't be empty ");
        }
        if (StringUtils.isBlank((String)tenantVo.getDesc())) {
            throw new ConfigurationException("Description can't be empty ");
        }
        if (StringUtils.isBlank((String)tenantVo.getTenantValue())) {
            throw new ConfigurationException("Tenant tag can't be empty ");
        }
        if (tenantVo.getCreator().equals("*") && tenantVo.getUser().equals("*")) {
            throw new ConfigurationException("User && Creator cannot be both *");
        }
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="DepartmentTenantVo", name="departmentTenantVo", value="departmentTenantVo")})
    @ApiOperation(value="save-department-tenant", notes="save department tenant", httpMethod="POST", response=Message.class)
    @RequestMapping(path={"/save-department-tenant"}, method={RequestMethod.POST})
    public Message saveDepartmentTenant(HttpServletRequest req, @RequestBody DepartmentTenantVo departmentTenantVo) throws ConfigurationException {
        DepartmentTenantVo departTenant;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"execute saveDepartmentTenant");
        if (!Configuration.isAdmin((String)userName)) {
            return Message.error((String)"Failed to save-department-tenant,msg: only administrator users to use");
        }
        if (StringUtils.isBlank((String)departmentTenantVo.getTenantValue())) {
            return Message.error((String)"tenant can not be empty");
        }
        if (StringUtils.isBlank((String)departmentTenantVo.getCreator())) {
            return Message.error((String)"creator can not be empty");
        }
        if (StringUtils.isBlank((String)departmentTenantVo.getDepartmentId())) {
            return Message.error((String)"departmentId can not be empty");
        }
        if (StringUtils.isBlank((String)departmentTenantVo.getId()) && null != (departTenant = this.tenantConfigService.queryDepartTenant(departmentTenantVo.getCreator(), departmentTenantVo.getDepartmentId()))) {
            return Message.error((String)"department creator is exist");
        }
        this.tenantConfigService.saveDepartmentTenant(departmentTenantVo);
        return Message.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="department", value="department"), @ApiImplicitParam(paramType="query", dataType="string", name="creator", value="creator"), @ApiImplicitParam(paramType="query", dataType="string", name="tenantValue", value="tenantValue"), @ApiImplicitParam(paramType="query", dataType="int", name="pageNow", value="pageNow"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize", value="pageSize")})
    @ApiOperation(value="query-department-tenant", notes="query department tenant list", httpMethod="GET", response=Message.class)
    @RequestMapping(path={"/query-department-tenant"}, method={RequestMethod.GET})
    public Message queryDepartmentTenant(HttpServletRequest req, @RequestParam(value="departmentId", required=false) String departmentId, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="tenantValue", required=false) String tenantValue, @RequestParam(value="pageNow", required=false, defaultValue="1") Integer pageNow, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"execute queryDepartmentTenantList");
        if (!Configuration.isAdmin((String)userName)) {
            return Message.error((String)"Failed to query-tenant-list,msg: only administrator users to use");
        }
        if (StringUtils.isBlank((String)departmentId)) {
            departmentId = null;
        }
        if (StringUtils.isBlank((String)creator)) {
            creator = null;
        }
        if (StringUtils.isBlank((String)tenantValue)) {
            tenantValue = null;
        }
        Map<String, Object> resultMap = this.tenantConfigService.queryDepartmentTenant(departmentId, creator, tenantValue, pageNow, pageSize);
        return Message.ok().data("tenantList", resultMap.get("tenantList")).data(JobRequestConstants.TOTAL_PAGE(), resultMap.get(JobRequestConstants.TOTAL_PAGE()));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="int", name="id", value="id")})
    @ApiOperation(value="delete-department-tenant", notes="delete department tenant", httpMethod="GET", response=Message.class)
    @RequestMapping(path={"/delete-department-tenant"}, method={RequestMethod.GET})
    public Message deleteDepartmentTenant(HttpServletRequest req, @RequestParam(value="id") Integer id) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("execute deleteDepartmentTenant,id: " + id));
        if (!Configuration.isAdmin((String)userName)) {
            return Message.error((String)"Failed to delete-department-tenant,msg: only administrator users to use");
        }
        if (StringUtils.isBlank((String)id.toString())) {
            return Message.error((String)"id can not be empty");
        }
        this.tenantConfigService.deleteDepartmentTenant(id);
        return Message.ok();
    }

    @ApiOperation(value="query department", notes="query department", httpMethod="GET", response=Message.class)
    @RequestMapping(path={"/query-department"}, method={RequestMethod.GET})
    public Message queryDepartmentList() {
        return Message.ok().data("departmentList", this.tenantConfigService.queryDepartmentList());
    }

    @RequestMapping(path={"/query-user-department"}, method={RequestMethod.GET})
    public Message queryDepartmentList(HttpServletRequest req, @RequestParam(value="username") String username) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("query department of " + username));
        return Message.ok().data("department", (Object)this.tenantConfigService.getDepartmentByUser(username));
    }
}

