/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.configuration.dao.ConfigMapper;
import org.apache.linkis.configuration.dao.LabelMapper;
import org.apache.linkis.configuration.entity.CategoryLabel;
import org.apache.linkis.configuration.entity.CategoryLabelVo;
import org.apache.linkis.configuration.entity.ConfigKey;
import org.apache.linkis.configuration.entity.ConfigLabel;
import org.apache.linkis.configuration.entity.ConfigValue;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.ConfigurationService;
import org.apache.linkis.configuration.util.LabelEntityParser;
import org.apache.linkis.manager.label.builder.CombinedLabelBuilder;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\r\u001b\u0001\u0015BQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001d\t\u0013\u0001\u0003\u0001\u0019!a\u0001\n\u0013\t\u0005\"C$\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011%)\u0006\u00011AA\u0002\u0013%a\u000bC\u0005[\u0001\u0001\u0007\t\u0019!C\u00057\"IQ\f\u0001a\u0001\u0002\u0003\u0006Ka\u0016\u0005\n?\u0002\u0001\r\u00111A\u0005\n\u0001D\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011B3\t\u0013\u001d\u0004\u0001\u0019!A!B\u0013\t\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007k\u0002\u0001\u000b\u0011B6\t\u000bY\u0004A\u0011A<\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!a\"\u0001\t\u0003\tI\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003w\u0003A\u0011AA_\u0005=\u0019\u0015\r^3h_JL8+\u001a:wS\u000e,'BA\u000e\u001d\u0003\u001d\u0019XM\u001d<jG\u0016T!!\b\u0010\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\ty\u0002%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQ!\u001e;jYNT!!\r\u0010\u0002\r\r|W.\\8o\u0013\t\u0019dFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00051\u0004CA\u001c\u0001\u001b\u0005Q\u0012\u0001D2p]\u001aLw-T1qa\u0016\u0014X#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ub\u0012a\u00013b_&\u0011q\b\u0010\u0002\r\u0007>tg-[4NCB\u0004XM]\u0001\u0011G>tg-[4NCB\u0004XM]0%KF$\"AQ#\u0011\u0005\u001d\u001a\u0015B\u0001#)\u0005\u0011)f.\u001b;\t\u000f\u0019\u001b\u0011\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\u0002\u001b\r|gNZ5h\u001b\u0006\u0004\b/\u001a:!Q\t!\u0011\n\u0005\u0002K'6\t1J\u0003\u0002M\u001b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00059{\u0015a\u00024bGR|'/\u001f\u0006\u0003!F\u000bQAY3b]NT!A\u0015\u0012\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.L!\u0001V&\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001F2p]\u001aLw-\u001e:bi&|gnU3sm&\u001cW-F\u0001X!\t9\u0004,\u0003\u0002Z5\t!2i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016\f\u0001dY8oM&<WO]1uS>t7+\u001a:wS\u000e,w\fJ3r)\t\u0011E\fC\u0004G\r\u0005\u0005\t\u0019A,\u0002+\r|gNZ5hkJ\fG/[8o'\u0016\u0014h/[2fA!\u0012q!S\u0001\fY\u0006\u0014W\r\\'baB,'/F\u0001b!\tY$-\u0003\u0002dy\tYA*\u00192fY6\u000b\u0007\u000f]3s\u0003=a\u0017MY3m\u001b\u0006\u0004\b/\u001a:`I\u0015\fHC\u0001\"g\u0011\u001d1\u0015\"!AA\u0002\u0005\fA\u0002\\1cK2l\u0015\r\u001d9fe\u0002B#AC%\u0002)\r|WNY5oK\u0012d\u0015MY3m\u0005VLG\u000eZ3s+\u0005Y\u0007C\u00017t\u001b\u0005i'B\u00018p\u0003\u001d\u0011W/\u001b7eKJT!\u0001]9\u0002\u000b1\f'-\u001a7\u000b\u0005It\u0012aB7b]\u0006<WM]\u0005\u0003i6\u0014AcQ8nE&tW\r\u001a'bE\u0016d')^5mI\u0016\u0014\u0018!F2p[\nLg.\u001a3MC\n,GNQ;jY\u0012,'\u000fI\u0001\u000eg\u0016$8)\u0019;fO>\u0014\u0018PV8\u0015\t\tC\u0018\u0011\u0001\u0005\u0006s6\u0001\rA_\u0001\u0003m>\u0004\"a\u001f@\u000e\u0003qT!! \u000f\u0002\r\u0015tG/\u001b;z\u0013\tyHPA\bDCR,wm\u001c:z\u0019\u0006\u0014W\r\u001c,p\u0011\u001d\t\u0019!\u0004a\u0001\u0003\u000b\tQbY1uK\u001e|'/\u001f'bE\u0016d\u0007cA>\u0002\b%\u0019\u0011\u0011\u0002?\u0003\u001b\r\u000bG/Z4pefd\u0015MY3m\u0003E\u0011W/\u001b7e\u0007\u0006$XmZ8ssR\u0013X-\u001a\u000b\u0005\u0003\u001f\ty\u0002E\u0003\u0002\u0012\u0005m!0\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\t!A*[:u\u0011\u001d\t\tC\u0004a\u0001\u0003G\t\u0011cY1uK\u001e|'/\u001f'bE\u0016dG*[:u!\u0019\t\t\"a\u0007\u0002\u0006\u0005qq-\u001a;BY2\u001c\u0015\r^3h_JLH\u0003BA\b\u0003SAq!a\u000b\u0010\u0001\u0004\ti#\u0001\u0005mC:<W/Y4f!\u0011\ty#!\u0010\u000f\t\u0005E\u0012\u0011\b\t\u0004\u0003gASBAA\u001b\u0015\r\t9\u0004J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m\u0002&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\t\tE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003wA\u0013aD4fi\u000e\u000bG/Z4pef\u0014\u00150\u00133\u0015\t\u0005\u001d\u0013Q\n\t\u0005O\u0005%#0C\u0002\u0002L!\u0012aa\u00149uS>t\u0007bBA(!\u0001\u0007\u0011\u0011K\u0001\u000bG\u0006$XmZ8ss&#\u0007\u0003BA*\u00033j!!!\u0016\u000b\t\u0005]\u0013qC\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\\\u0005U#aB%oi\u0016<WM]\u0001\u0016O\u0016tWM]1uK\u000e\u000bG/Z4pefd\u0015MY3m)!\t)!!\u0019\u0002f\u0005%\u0004bBA2#\u0001\u0007\u0011\u0011K\u0001\bY\u0006\u0014W\r\\%e\u0011\u001d\t9'\u0005a\u0001\u0003[\t1\u0002Z3tGJL\u0007\u000f^5p]\"9\u00111N\tA\u0002\u0005E\u0013!\u00027fm\u0016d\u0017aE2sK\u0006$XMR5sgR\u001c\u0015\r^3h_JLH#\u0002\"\u0002r\u0005U\u0004bBA:%\u0001\u0007\u0011QF\u0001\rG\u0006$XmZ8ss:\u000bW.\u001a\u0005\b\u0003O\u0012\u0002\u0019AA\u0017Q\r\u0011\u0012\u0011\u0010\t\u0005\u0003w\n\u0019)\u0004\u0002\u0002~)\u0019A*a \u000b\u0007\u0005\u0005\u0015+A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BAC\u0003{\u0012Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017AE1tg>\u001c\u0017.\u0019;f\u0007>tg-[4LKf$RAQAF\u0003\u001bCq!a\u0019\u0014\u0001\u0004\t\t\u0006C\u0004\u0002\u0010N\u0001\r!!\f\u0002\u0017M$(/\u001b8h-\u0006dW/\u001a\u0015\u0004'\u0005e\u0014\u0001F2sK\u0006$XmU3d_:$7)\u0019;fO>\u0014\u0018\u0010F\u0005C\u0003/\u000bI*!(\u0002\"\"9\u0011q\n\u000bA\u0002\u0005E\u0003bBAN)\u0001\u0007\u0011QF\u0001\u000bK:<\u0017N\\3UsB,\u0007bBAP)\u0001\u0007\u0011QF\u0001\bm\u0016\u00148/[8o\u0011\u001d\t9\u0007\u0006a\u0001\u0003[A3\u0001FA=\u00039!W\r\\3uK\u000e\u000bG/Z4pef$2AQAU\u0011\u001d\ty%\u0006a\u0001\u0003#B3!FA=\u00035!W\r\\3uK\u0006cGNT8eKR\u0019!)!-\t\u000f\u0005=c\u00031\u0001\u0002R\u0005qQ\u000f\u001d3bi\u0016\u001c\u0015\r^3h_JLH#\u0002\"\u00028\u0006e\u0006bBA(/\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003O:\u0002\u0019AA\u0017\u0003E!W\r\\3uK\u000e+(O]3oi:{G-\u001a\u000b\u0004\u0005\u0006}\u0006bBA(1\u0001\u0007\u0011\u0011\u000b\u0015\u0004\u0001\u0005\r\u0007\u0003BAc\u0003\u0017l!!a2\u000b\u0007\u0005%\u0017+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!4\u0002H\n91+\u001a:wS\u000e,\u0007")
public class CategoryService
implements Logging {
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private LabelMapper labelMapper;
    private final CombinedLabelBuilder combinedLabelBuilder;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CategoryService categoryService = this;
        synchronized (categoryService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ConfigMapper configMapper() {
        return this.configMapper;
    }

    private void configMapper_$eq(ConfigMapper x$1) {
        this.configMapper = x$1;
    }

    private ConfigurationService configurationService() {
        return this.configurationService;
    }

    private void configurationService_$eq(ConfigurationService x$1) {
        this.configurationService = x$1;
    }

    private LabelMapper labelMapper() {
        return this.labelMapper;
    }

    private void labelMapper_$eq(LabelMapper x$1) {
        this.labelMapper = x$1;
    }

    private CombinedLabelBuilder combinedLabelBuilder() {
        return this.combinedLabelBuilder;
    }

    public void setCategoryVo(CategoryLabelVo vo, CategoryLabel categoryLabel) {
        vo.setCategoryId(categoryLabel.getCategoryId());
        vo.setLabelId(categoryLabel.getId());
        vo.setCreateTime(categoryLabel.getCreateTime());
        vo.setUpdateTime(categoryLabel.getUpdateTime());
        vo.setLevel(categoryLabel.getLevel());
        if (StringUtils.isNotEmpty((CharSequence)categoryLabel.getDescription())) {
            vo.setDescription(categoryLabel.getDescription());
        }
        if (StringUtils.isNotEmpty((CharSequence)categoryLabel.getTag())) {
            vo.setTag(categoryLabel.getTag());
            return;
        }
    }

    public List<CategoryLabelVo> buildCategoryTree(List<CategoryLabel> categoryLabelList) {
        ArrayList<CategoryLabelVo> firstCategoryList = new ArrayList<CategoryLabelVo>();
        ArrayList secondaryCategoryList = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(categoryLabelList).asScala()).foreach((Function1 & Serializable & scala.Serializable)categoryLabel -> {
            CategoryService.$anonfun$buildCategoryTree$1(this, firstCategoryList, secondaryCategoryList, categoryLabel);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(secondaryCategoryList).asScala()).foreach((Function1 & Serializable & scala.Serializable)secondaryVo -> BoxesRunTime.boxToBoolean((boolean)CategoryService.$anonfun$buildCategoryTree$3(firstCategoryList, secondaryVo)));
        return firstCategoryList;
    }

    public List<CategoryLabelVo> getAllCategory(String language) {
        List<CategoryLabelVo> categoryLabelTreeList;
        block0: {
            List<CategoryLabel> categoryLabelList = this.configMapper().getCategory();
            categoryLabelTreeList = this.buildCategoryTree(categoryLabelList);
            if ("en".equals(language)) break block0;
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(categoryLabelTreeList).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CategoryService.$anonfun$getAllCategory$1(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.setCategoryName(Configuration$.MODULE$.GLOBAL_CONF_CHN_NAME());
                return BoxedUnit.UNIT;
            });
        }
        return categoryLabelTreeList;
    }

    public Option<CategoryLabelVo> getCategoryById(Integer categoryId) {
        List<CategoryLabelVo> categoryLabelTreeList = this.getAllCategory(null);
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(categoryLabelTreeList).asScala()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CategoryService.$anonfun$getCategoryById$1(categoryId, x$4)));
    }

    public CategoryLabel generateCategoryLabel(Integer labelId, String description, Integer level) {
        CategoryLabel categoryLabel = new CategoryLabel();
        categoryLabel.setId(labelId);
        categoryLabel.setDescription(description);
        categoryLabel.setLevel(level);
        return categoryLabel;
    }

    @Transactional
    public void createFirstCategory(String categoryName, String description) {
        Buffer categoryList = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getAllCategory(null)).asScala()).map((Function1 & Serializable & scala.Serializable)category -> category.getCategoryName().toLowerCase(), Buffer$.MODULE$.canBuildFrom());
        if (categoryList.contains((Object)categoryName.toLowerCase(Locale.ROOT))) {
            throw new ConfigurationException(new StringBuilder(58).append("category name : ").append(categoryName).append(" is exist, cannot be created(\u76ee\u5f55\u540d\uff1a").append(categoryName).append("\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa)").toString());
        }
        CombinedLabel combinedLabel = this.configurationService().generateCombinedLabel(null, null, null, categoryName);
        ConfigLabel parsedLabel = LabelEntityParser.parseToConfigLabel(combinedLabel);
        ConfigLabel configValue = this.labelMapper().getLabelByKeyValue(parsedLabel.getLabelKey(), parsedLabel.getStringValue());
        if (configValue != null) {
            parsedLabel.setId(configValue.getId());
        } else {
            this.labelMapper().insertLabel(parsedLabel);
        }
        if (parsedLabel.getId() != null) {
            CategoryLabel categoryLabel = this.generateCategoryLabel(parsedLabel.getId(), description, Predef$.MODULE$.int2Integer(1));
            this.configMapper().insertCategory(categoryLabel);
            this.logger().info(new StringBuilder(64).append("success to create category: ").append(categoryName).append(" --category id: ").append(categoryLabel.getCategoryId()).append(" ").append("--category level: 1").toString());
            return;
        }
    }

    @Transactional
    public void associateConfigKey(Integer labelId, String stringValue) {
        if (!StringUtils.isEmpty((CharSequence)stringValue) && labelId != null) {
            List<ConfigKey> keyList = this.configMapper().listKeyByStringValue(stringValue);
            Buffer keyIdList = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(keyList).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Buffer$.MODULE$.canBuildFrom());
            if (!keyIdList.isEmpty()) {
                ArrayList configValueList = new ArrayList();
                keyIdList.foreach((Function1 & Serializable & scala.Serializable)keyId -> BoxesRunTime.boxToBoolean((boolean)CategoryService.$anonfun$associateConfigKey$2(labelId, configValueList, keyId)));
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.configMapper().insertValueList(configValueList));
                return;
            }
            return;
        }
    }

    @Transactional
    public void createSecondCategory(Integer categoryId, String engineType, String version, String description) {
        boolean bl;
        Option<CategoryLabelVo> categoryTree = this.getCategoryById(categoryId);
        CategoryLabelVo categoryList = (CategoryLabelVo)categoryTree.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigurationException(new StringBuilder(61).append("category id : ").append(categoryId).append(" is not exist, cannot be created(\u76ee\u5f55id\uff1a").append(categoryId).append("\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa)").toString());
        });
        Buffer childList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(categoryList.getChildCategory()).asScala();
        if (childList != null && !((SeqLike)childList.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CategoryService.$anonfun$createSecondCategory$2(engineType, version, x$6)))).isEmpty()) {
            throw new ConfigurationException(new StringBuilder(41).append(engineType).append("-").append(version).append(" is exist, cannot be created(").append(engineType).append("-").append(version).append("\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa)").toString());
        }
        String string = categoryList.getCategoryName();
        String string2 = Configuration$.MODULE$.GLOBAL_CONF_CHN_NAME();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = Configuration$.MODULE$.GLOBAL_CONF_CHN_OLDNAME();
            String string5 = string;
            bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl) {
            throw new ConfigurationException("Global setting do not allow the configuration of engines to be added(\u5168\u5c40\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5f15\u64ce\u914d\u7f6e!)");
        }
        String creator = categoryList.getCategoryName();
        CombinedLabel combinedLabel = this.configurationService().generateCombinedLabel(engineType, version, null, creator);
        ConfigLabel parsedLabel = LabelEntityParser.parseToConfigLabel(combinedLabel);
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.labelMapper().insertLabel(parsedLabel), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            CategoryService.$anonfun$createSecondCategory$4(this, parsedLabel, x0$1);
            return BoxedUnit.UNIT;
        });
        if (parsedLabel.getId() != null) {
            CategoryLabel categoryLabel = this.generateCategoryLabel(parsedLabel.getId(), description, Predef$.MODULE$.int2Integer(2));
            this.configMapper().insertCategory(categoryLabel);
            this.logger().info(new StringBuilder(64).append("success to create category: ").append(combinedLabel.getStringValue()).append(" --category id: ").append(categoryLabel.getCategoryId()).append(" ").append("--category level: 2").toString());
            CombinedLabel linkedEngineTypeLabel = this.configurationService().generateCombinedLabel(engineType, version, null, null);
            ConfigLabel linkedEngineTypeLabelInDb = this.labelMapper().getLabelByKeyValue(linkedEngineTypeLabel.getLabelKey(), linkedEngineTypeLabel.getStringValue());
            if (linkedEngineTypeLabelInDb != null) {
                this.associateConfigKey(linkedEngineTypeLabelInDb.getId(), linkedEngineTypeLabel.getStringValue());
                return;
            }
            ConfigLabel engineLabel = LabelEntityParser.parseToConfigLabel(linkedEngineTypeLabel);
            this.labelMapper().insertLabel(engineLabel);
            return;
        }
    }

    @Transactional
    public void deleteCategory(Integer categoryId) {
        if (Predef$.MODULE$.Integer2int(categoryId) > 0) {
            CategoryLabel categoryLabel = this.configMapper().getCategoryById(categoryId);
            if (categoryLabel == null) {
                throw new ConfigurationException(new StringBuilder(51).append("cannot find category, categoryId:").append(categoryId).append("(\u6ca1\u6709\u627e\u5230\u8981\u5220\u9664\u7684\u76ee\u5f55\uff0c\u76ee\u5f55Id:").append(categoryId).append(")").toString());
            }
            int n = Predef$.MODULE$.Integer2int(categoryLabel.getLevel());
            switch (n) {
                case 1: {
                    this.deleteAllNode(categoryId);
                    return;
                }
            }
            this.deleteCurrentNode(categoryId);
            return;
        }
    }

    public void deleteAllNode(Integer categoryId) {
        CategoryLabelVo categoryLabelVo = (CategoryLabelVo)this.getCategoryById(categoryId).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        if (categoryLabelVo != null) {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(categoryLabelVo.getCategoryId());
            Buffer childCategoryList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(categoryLabelVo.getChildCategory()).asScala();
            childCategoryList.foreach((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)idList.add(child.getCategoryId())));
            this.configMapper().deleteCategory(idList);
            idList.clear();
            idList.add(categoryLabelVo.getLabelId());
            childCategoryList.foreach((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)idList.add(child.getLabelId())));
            this.labelMapper().deleteLabel(idList);
            this.logger().info(new StringBuilder(49).append("success to delete category:").append(categoryLabelVo.getCategoryName()).append(", ").append("with child category:").append(((TraversableOnce)childCategoryList.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getCategoryName(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))).toString());
            return;
        }
    }

    public void updateCategory(Integer categoryId, String description) {
        CategoryLabel categoryLabel = new CategoryLabel();
        categoryLabel.setCategoryId(categoryId);
        categoryLabel.setDescription(description);
        this.configMapper().updateCategory(categoryLabel);
    }

    public void deleteCurrentNode(Integer categoryId) {
        CategoryLabel categoryLabel = this.configMapper().getCategoryById(categoryId);
        if (categoryLabel != null) {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            idList.add(categoryId);
            this.configMapper().deleteCategory(idList);
            idList.clear();
            idList.add(categoryLabel.getId());
            this.labelMapper().deleteLabel(idList);
            this.logger().info(new StringBuilder(27).append("success to delete category:").append(categoryLabel.getStringValue()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$buildCategoryTree$1(CategoryService $this, ArrayList firstCategoryList$1, ArrayList secondaryCategoryList$1, CategoryLabel categoryLabel) {
        CategoryLabelVo vo = new CategoryLabelVo();
        $this.setCategoryVo(vo, categoryLabel);
        CombinedLabel combinedLabel = (CombinedLabel)$this.combinedLabelBuilder().buildFromStringValue(categoryLabel.getLabelKey(), categoryLabel.getStringValue());
        List labelList = (List)combinedLabel.getValue();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(labelList).asScala()).foreach((Function1 & Serializable & scala.Serializable)label -> {
            Label label2 = label;
            if (label2 instanceof UserCreatorLabel) {
                UserCreatorLabel userCreatorLabel = (UserCreatorLabel)label2;
                if (BoxesRunTime.equalsNumObject((Number)categoryLabel.getLevel(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                    vo.setCategoryName(userCreatorLabel.getCreator());
                    return BoxesRunTime.boxToBoolean((boolean)firstCategoryList$1.add(vo));
                }
                if (BoxesRunTime.equalsNumObject((Number)categoryLabel.getLevel(), (Object)BoxesRunTime.boxToInteger((int)2))) {
                    vo.setFatherCategoryName(userCreatorLabel.getCreator());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            if (label2 instanceof EngineTypeLabel) {
                EngineTypeLabel engineTypeLabel = (EngineTypeLabel)label2;
                if (BoxesRunTime.equalsNumObject((Number)categoryLabel.getLevel(), (Object)BoxesRunTime.boxToInteger((int)2))) {
                    vo.setCategoryName(engineTypeLabel.getStringValue());
                    return BoxesRunTime.boxToBoolean((boolean)secondaryCategoryList$1.add(vo));
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$buildCategoryTree$4(CategoryLabelVo secondaryVo$1, CategoryLabelVo x$1) {
        return x$1.getCategoryName().equals(secondaryVo$1.getFatherCategoryName());
    }

    public static final /* synthetic */ boolean $anonfun$buildCategoryTree$3(ArrayList firstCategoryList$1, CategoryLabelVo secondaryVo) {
        return ((CategoryLabelVo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)firstCategoryList$1).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CategoryService.$anonfun$buildCategoryTree$4(secondaryVo, x$1))).get()).getChildCategory().add(secondaryVo);
    }

    public static final /* synthetic */ boolean $anonfun$getAllCategory$1(CategoryLabelVo x$2) {
        return BoxesRunTime.equalsNumObject((Number)x$2.getCategoryId(), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ boolean $anonfun$getCategoryById$1(Integer categoryId$1, CategoryLabelVo x$4) {
        Integer n = x$4.getCategoryId();
        Integer n2 = categoryId$1;
        return !(n != null ? !((Object)n).equals(n2) : n2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$associateConfigKey$2(Integer labelId$1, ArrayList configValueList$1, Long keyId) {
        ConfigValue configValue = new ConfigValue();
        configValue.setConfigKeyId(keyId);
        configValue.setConfigValue("");
        configValue.setConfigLabelId(labelId$1);
        return configValueList$1.add(configValue);
    }

    public static final /* synthetic */ boolean $anonfun$createSecondCategory$2(String engineType$1, String version$1, CategoryLabelVo x$6) {
        return x$6.getCategoryName().toLowerCase(Locale.ROOT).equals(new StringBuilder(1).append(engineType$1.toLowerCase(Locale.ROOT)).append("-").append(version$1).toString());
    }

    public static final /* synthetic */ void $anonfun$createSecondCategory$4(CategoryService $this, ConfigLabel parsedLabel$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof DuplicateKeyException) {
            parsedLabel$1.setId($this.labelMapper().getLabelByKeyValue(parsedLabel$1.getLabelKey(), parsedLabel$1.getStringValue()).getId());
            return;
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            throw exception;
        }
        throw new MatchError((Object)throwable);
    }

    public CategoryService() {
        Logging.$init$((Logging)this);
        this.combinedLabelBuilder = new CombinedLabelBuilder();
    }
}

