/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public class ParquetHiveArrayInspector
implements SettableListObjectInspector {
    ObjectInspector arrayElementInspector;

    public ParquetHiveArrayInspector(ObjectInspector arrayElementInspector) {
        this.arrayElementInspector = arrayElementInspector;
    }

    @Override
    public String getTypeName() {
        return "array<" + this.arrayElementInspector.getTypeName() + ">";
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }

    @Override
    public ObjectInspector getListElementObjectInspector() {
        return this.arrayElementInspector;
    }

    @Override
    public Object getListElement(Object data, int index) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            Writable[] array = ((ArrayWritable)data).get();
            if (array == null || array.length == 0) {
                return null;
            }
            if (index >= 0 && index < array.length) {
                return array[index];
            }
            return null;
        }
        if (data instanceof List) {
            return ((List)data).get(index);
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    @Override
    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        if (data instanceof ArrayWritable) {
            Writable[] array = ((ArrayWritable)data).get();
            if (array == null) {
                return -1;
            }
            return array.length;
        }
        if (data instanceof List) {
            return ((List)data).size();
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    @Override
    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            Writable[] array = ((ArrayWritable)data).get();
            if (array == null) {
                return null;
            }
            return new ArrayList<Writable>(Arrays.asList(array));
        }
        if (data instanceof List) {
            return (List)data;
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    @Override
    public Object create(int size) {
        return new ArrayList<Object>(Arrays.asList(new Object[size]));
    }

    @Override
    public Object set(Object list, int index, Object element) {
        List l = (List)list;
        l.set(index, element);
        return list;
    }

    @Override
    public Object resize(Object list, int newSize) {
        List l = (List)list;
        int deltaSize = newSize - l.size();
        if (deltaSize > 0) {
            l.addAll(Arrays.asList(new Object[deltaSize]));
        } else {
            int size = l.size();
            l.subList(size + deltaSize, size).clear();
        }
        return list;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ObjectInspector other = ((ParquetHiveArrayInspector)o).arrayElementInspector;
        return other.equals(this.arrayElementInspector);
    }

    public int hashCode() {
        return this.arrayElementInspector != null ? this.arrayElementInspector.hashCode() : 0;
    }
}

