/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.governance.common.paser;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.paser.CodeType$;
import org.apache.linkis.governance.common.paser.SingleCodeParser;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0004\b\u00017!)q\u0005\u0001C\u0001Q!9!\u0006\u0001b\u0001\n\u0003Z\u0003B\u0002\"\u0001A\u0003%A\u0006C\u0004D\u0001\t\u0007I\u0011\u0001#\t\r5\u0003\u0001\u0015!\u0003F\u0011\u001dq\u0005A1A\u0005\u0002\u0011Caa\u0014\u0001!\u0002\u0013)\u0005b\u0002)\u0001\u0005\u0004%\t!\u0015\u0005\u00071\u0002\u0001\u000b\u0011\u0002*\t\u000be\u0003A\u0011\u0002.\t\u000b\u001d\u0004A\u0011\t5\t\u000b1\u0004A\u0011A7\u0003\u001bM\u000bFjQ8eKB\u000b'o]3s\u0015\ty\u0001#A\u0003qCN,'O\u0003\u0002\u0012%\u000511m\\7n_:T!a\u0005\u000b\u0002\u0015\u001d|g/\u001a:oC:\u001cWM\u0003\u0002\u0016-\u00051A.\u001b8lSNT!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dAA\u0011QDH\u0007\u0002\u001d%\u0011qD\u0004\u0002\u0011'&tw\r\\3D_\u0012,\u0007+\u0019:tKJ\u0004\"!I\u0013\u000e\u0003\tR!a\t\u0013\u0002\u000bU$\u0018\u000e\\:\u000b\u0005E!\u0012B\u0001\u0014#\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0015\u0011\u0005u\u0001\u0011\u0001C2pI\u0016$\u0016\u0010]3\u0016\u00031\u0002\"!L \u000f\u00059jdBA\u0018=\u001d\t\u00014H\u0004\u00022u9\u0011!'\u000f\b\u0003gar!\u0001N\u001c\u000e\u0003UR!A\u000e\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA\f\u0019\u0013\t)b#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI!A\u0010\b\u0002\u0011\r{G-\u001a+za\u0016L!\u0001Q!\u0003\u0011\r{G-\u001a+za\u0016T!A\u0010\b\u0002\u0013\r|G-\u001a+za\u0016\u0004\u0013!C:fa\u0006\u0014\u0018\r^8s+\u0005)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0011a\u0017M\\4\u000b\u0003)\u000bAA[1wC&\u0011Aj\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015M,\u0007/\u0019:bi>\u0014\b%\u0001\tta\u0016\u001c\u0017.\u00197TKB\f'/\u0019;pe\u0006\t2\u000f]3dS\u0006d7+\u001a9be\u0006$xN\u001d\u0011\u0002\u0019\u0011,g-Y;mi2KW.\u001b;\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u00131!\u00138u\u00035!WMZ1vYRd\u0015.\\5uA\u00051b-\u001b8e%\u0016\fGnU3nS\u000e|Gn\u001c8J]\u0012,\u0007\u0010\u0006\u0002\\=B\u00191\u000b\u0018*\n\u0005u#&!B!se\u0006L\b\"B0\u000b\u0001\u0004\u0001\u0017\u0001\u0003;f[B\u001cu\u000eZ3\u0011\u0005\u0005,gB\u00012d!\t!D+\u0003\u0002e)\u00061\u0001K]3eK\u001aL!\u0001\u00144\u000b\u0005\u0011$\u0016!\u00029beN,GCA5k!\r\u0019F\f\u0019\u0005\u0006W.\u0001\r\u0001Y\u0001\u0005G>$W-\u0001\njgN+G.Z2u\u00076$gj\u001c'j[&$HC\u00018r!\t\u0019v.\u0003\u0002q)\n9!i\\8mK\u0006t\u0007\"\u0002:\r\u0001\u0004\u0001\u0017aA2nI\u0002")
public class SQLCodeParser
extends SingleCodeParser
implements Logging {
    private final Enumeration.Value codeType;
    private final String separator;
    private final String specialSeparator;
    private final int defaultLimit;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SQLCodeParser sQLCodeParser = this;
        synchronized (sQLCodeParser) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Enumeration.Value codeType() {
        return this.codeType;
    }

    public String separator() {
        return this.separator;
    }

    public String specialSeparator() {
        return this.specialSeparator;
    }

    public int defaultLimit() {
        return this.defaultLimit;
    }

    private int[] findRealSemicolonIndex(String tempCode) {
        ObjectRef realTempCode = ObjectRef.create((Object)(!tempCode.endsWith(";") ? new StringBuilder(1).append(tempCode).append(";").toString() : tempCode));
        realTempCode.elem = ((String)realTempCode.elem).replace("\\\"", "AA").replace("\\'", "AA");
        Regex re = new StringOps(Predef$.MODULE$.augmentString("(['\"])(?:(?!\\1).)*?\\1")).r();
        ArrayBuffer array = new ArrayBuffer();
        List uglyIndices = re.findAllMatchIn((CharSequence)((String)realTempCode.elem)).map((Function1 & Serializable & scala.Serializable)m -> new Tuple2.mcII.sp(m.start(), m.end())).toList();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((String)realTempCode.elem).length()).foreach((Function1 & Serializable & scala.Serializable)i -> SQLCodeParser.$anonfun$findRealSemicolonIndex$2(realTempCode, uglyIndices, array, BoxesRunTime.unboxToInt((Object)i)));
        return (int[])array.toArray(ClassTag$.MODULE$.Int());
    }

    @Override
    public String[] parse(String code) {
        ArrayBuffer codeBuffer = new ArrayBuffer();
        if (StringUtils.isBlank((CharSequence)code)) {
            return (String[])codeBuffer.toArray(ClassTag$.MODULE$.apply(String.class));
        }
        int[] indices = this.findRealSemicolonIndex(code);
        IntRef oldIndex = IntRef.create((int)0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String singleCode = code.substring(oldIndex$1.elem, index);
            oldIndex$1.elem = index + 1;
            if (StringUtils.isNotBlank((CharSequence)singleCode)) {
                SQLCodeParser.appendStatement$1(singleCode, codeBuffer);
                return;
            }
        });
        return (String[])codeBuffer.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean isSelectCmdNoLimit(String cmd) {
        int limitNum;
        String code = cmd.trim();
        if (!cmd.split("\\s+")[0].equalsIgnoreCase("select")) {
            return false;
        }
        if (code.contains("limit")) {
            code = code.substring(code.lastIndexOf("limit")).trim();
        } else if (code.contains("LIMIT")) {
            code = code.substring(code.lastIndexOf("LIMIT")).trim().toLowerCase(Locale.getDefault());
        } else {
            return true;
        }
        boolean hasLimit = code.matches("limit\\s+\\d+\\s*;?");
        if (hasLimit && (limitNum = new StringOps(Predef$.MODULE$.augmentString(code = code.indexOf(";") > 0 ? code.substring(5, code.length() - 1).trim() : code.substring(5).trim())).toInt()) > this.defaultLimit()) {
            this.logger().warn(new StringBuilder(35).append("Limit num ").append(limitNum).append(" is over then max rows : ").append(this.defaultLimit()).toString());
        }
        return !hasLimit;
    }

    public static final /* synthetic */ boolean $anonfun$findRealSemicolonIndex$3(int i$1, Tuple2 se) {
        return i$1 < se._1$mcI$sp() || i$1 >= se._2$mcI$sp();
    }

    public static final /* synthetic */ Object $anonfun$findRealSemicolonIndex$2(ObjectRef realTempCode$1, List uglyIndices$1, ArrayBuffer array$1, int i) {
        if (';' == ((String)realTempCode$1.elem).charAt(i) && uglyIndices$1.forall((Function1 & Serializable & scala.Serializable)se -> BoxesRunTime.boxToBoolean((boolean)SQLCodeParser.$anonfun$findRealSemicolonIndex$3(i, se)))) {
            return array$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return BoxedUnit.UNIT;
    }

    private static final void appendStatement$1(String sqlStatement, ArrayBuffer codeBuffer$3) {
        codeBuffer$3.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sqlStatement}));
    }

    public SQLCodeParser() {
        Logging.$init$((Logging)this);
        this.codeType = CodeType$.MODULE$.SQL();
        this.separator = ";";
        this.specialSeparator = "\\;";
        this.defaultLimit = BoxesRunTime.unboxToInt((Object)GovernanceCommonConf$.MODULE$.ENGINE_DEFAULT_LIMIT().getValue());
    }
}

