/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.registry.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.registry.ServiceInstance;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstanceBase
implements ServiceInstance {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInstanceBase.class);
    private String host;
    private int rpcPort;
    private String workerIdentity;
    private Map<String, String> properties;

    public ServiceInstanceBase() {
    }

    public ServiceInstanceBase(ServiceRecord srv, String rpcName) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Working with ServiceRecord: {}", (Object)srv);
        }
        Endpoint rpc = srv.getInternalEndpoint(rpcName);
        this.host = RegistryTypeUtils.getAddressField((Map)((Map)rpc.addresses.get(0)), (String)"host");
        this.rpcPort = Integer.parseInt(RegistryTypeUtils.getAddressField((Map)((Map)rpc.addresses.get(0)), (String)"port"));
        this.workerIdentity = srv.get("registry.unique.id");
        this.properties = srv.attributes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInstanceBase other = (ServiceInstanceBase)o;
        return Objects.equals(this.getWorkerIdentity(), other.getWorkerIdentity()) && Objects.equals(this.host, other.host) && Objects.equals(this.rpcPort, other.rpcPort);
    }

    public int hashCode() {
        return this.getWorkerIdentity().hashCode() + 31 * this.host.hashCode() + 31 * this.rpcPort;
    }

    @Override
    public String getWorkerIdentity() {
        return this.workerIdentity;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getRpcPort() {
        return this.rpcPort;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public void setWorkerIdentity(String workerIdentity) {
        this.workerIdentity = workerIdentity;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String toString() {
        return "DynamicServiceInstance [id=" + this.getWorkerIdentity() + ", host=" + this.host + ":" + this.rpcPort + "]";
    }
}

