/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public abstract class PluginRegistrySupport<T extends Plugin<S>, S>
implements PluginRegistry<T, S>,
Iterable<T> {
    private List<T> plugins;
    private boolean initialized;

    public PluginRegistrySupport(List<? extends T> plugins) {
        Assert.notNull(plugins, (String)"Plugins must not be null!");
        this.plugins = plugins == null ? new ArrayList() : plugins;
        this.initialized = false;
    }

    @Override
    public List<T> getPlugins() {
        if (!this.initialized) {
            this.plugins = this.initialize(this.plugins);
            this.initialized = true;
        }
        return this.plugins;
    }

    protected synchronized List<T> initialize(List<T> plugins) {
        Assert.notNull(plugins, (String)"Plugins must not be null!");
        return plugins.stream().filter(it -> it != null).collect(Collectors.toList());
    }

    @Override
    public Iterator<T> iterator() {
        return this.getPlugins().iterator();
    }
}

