/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FieldAliasingMapper
extends MapperWrapper {
    protected final Map fieldToAliasMap = Collections.synchronizedMap(new HashMap());
    protected final Map aliasToFieldMap = Collections.synchronizedMap(new HashMap());

    public FieldAliasingMapper(ClassMapper wrapped) {
        super(wrapped);
    }

    public void addFieldAlias(String alias, Class type, String fieldName) {
        this.fieldToAliasMap.put(this.key(type, fieldName), alias);
        this.aliasToFieldMap.put(this.key(type, alias), fieldName);
    }

    private Object key(Class type, String value) {
        return type.getName() + '.' + value;
    }

    public String serializedMember(Class type, String memberName) {
        String alias = (String)this.fieldToAliasMap.get(this.key(type, memberName));
        if (alias == null) {
            return super.serializedMember(type, memberName);
        }
        return alias;
    }

    public String realMember(Class type, String serialized) {
        String real = (String)this.aliasToFieldMap.get(this.key(type, serialized));
        if (real == null) {
            return super.realMember(type, serialized);
        }
        return real;
    }
}

