/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.chainsaw.FileLoadAction;
import org.apache.log4j.chainsaw.FileSaveAction;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.osx.OSXIntegration;
import org.apache.log4j.chainsaw.prefs.MRUFileList;
import org.apache.log4j.xml.UtilLoggingXMLDecoder;
import org.apache.log4j.xml.XMLDecoder;

class FileMenu
extends JMenu {
    private Action loadConfigAction;
    private Action exitAction;
    private Action loadLog4JAction;
    private Action loadUtilLoggingAction;
    private Action remoteLog4JAction;
    private Action remoteUtilLoggingAction;
    private Action saveAction;

    public FileMenu(final LogUI logUI) {
        super("File");
        this.setMnemonic(70);
        this.loadConfigAction = new AbstractAction("Load Chainsaw configuration"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logUI.showReceiverConfiguration();
            }
        };
        this.loadLog4JAction = new FileLoadAction(logUI, new XMLDecoder(logUI), "Open log4j XML-formatted file (.xml or .zip)...", false);
        this.loadLog4JAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.loadLog4JAction.putValue("MnemonicKey", new Integer(76));
        this.loadLog4JAction.putValue("ShortDescription", "Loads events from a local XMLLayout-formatted file ");
        this.loadLog4JAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.FILE_OPEN));
        this.loadUtilLoggingAction = new FileLoadAction(logUI, new UtilLoggingXMLDecoder(logUI), "Open util.logging XML-formatted file (.xml or .zip)...", false);
        this.remoteLog4JAction = new FileLoadAction(logUI, new XMLDecoder(logUI), "Open remote log4j XML-formatted file (.xml or .zip)...", true);
        this.remoteUtilLoggingAction = new FileLoadAction(logUI, new UtilLoggingXMLDecoder(logUI), "Open remote util.logging XML-formatted file (.xml or .zip)...", true);
        this.saveAction = new FileSaveAction(logUI);
        JMenuItem loadChainsawConfig = new JMenuItem(this.loadConfigAction);
        JMenuItem loadLog4JFile = new JMenuItem(this.loadLog4JAction);
        JMenuItem loadUtilLoggingFile = new JMenuItem(this.loadUtilLoggingAction);
        JMenuItem remoteLog4JFile = new JMenuItem(this.remoteLog4JAction);
        JMenuItem remoteUtilLoggingFile = new JMenuItem(this.remoteUtilLoggingAction);
        JMenuItem saveFile = new JMenuItem(this.saveAction);
        this.exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logUI.exit();
            }
        };
        this.exitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.exitAction.putValue("ShortDescription", "Exits the Application");
        this.exitAction.putValue("MnemonicKey", new Integer(88));
        this.exitAction.putValue("Name", "Exit");
        JMenuItem menuItemExit = new JMenuItem(this.exitAction);
        this.add(loadChainsawConfig);
        this.add(loadLog4JFile);
        this.add(loadUtilLoggingFile);
        this.addSeparator();
        this.add(remoteLog4JFile);
        this.add(remoteUtilLoggingFile);
        this.addSeparator();
        this.add(saveFile);
        this.addSeparator();
        final JMenu mrulog4j = new JMenu("MRU...");
        MRUFileList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FileMenu.this.buildMRUMenu(mrulog4j, logUI);
            }
        });
        this.buildMRUMenu(mrulog4j, logUI);
        this.add(mrulog4j);
        if (!OSXIntegration.IS_OSX) {
            this.addSeparator();
            this.add(menuItemExit);
        }
    }

    private void buildMRUMenu(JMenu mrulog4j, final LogUI logui) {
        mrulog4j.removeAll();
        int counter = 1;
        if (MRUFileList.log4jMRU().getMRUList().size() > 0) {
            for (final URL url : MRUFileList.log4jMRU().getMRUList()) {
                final String name = url.getProtocol().startsWith("file") ? url.getPath().substring(url.getPath().lastIndexOf(47) + 1) : url.getPath();
                String title = counter++ + " - " + url.toExternalForm();
                JMenuItem menuItem = new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileLoadAction.importURL(logui.handler, new XMLDecoder(), name, url);
                    }
                });
                mrulog4j.add(menuItem);
            }
        } else {
            JMenuItem none = new JMenuItem("None as yet...");
            none.setEnabled(false);
            mrulog4j.add(none);
        }
    }

    Action getLog4JFileOpenAction() {
        return this.loadLog4JAction;
    }

    Action getUtilLoggingJFileOpenAction() {
        return this.loadUtilLoggingAction;
    }

    Action getFileSaveAction() {
        return this.saveAction;
    }

    Action getExitAction() {
        return this.exitAction;
    }
}

