/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.messages.MessageCenter;

public class ChainsawStatusBar
extends JPanel {
    private static final int DELAY_PERIOD = 5000;
    private static final String DEFAULT_MSG = "Welcome to Chainsaw v2!";
    private final JLabel statusMsg = new JLabel("Welcome to Chainsaw v2!");
    private final JLabel searchMatchLabel = new JLabel("", 0);
    private final JLabel pausedLabel = new JLabel("", 0);
    private final JLabel lineSelectionLabel = new JLabel("", 0);
    private final JLabel eventCountLabel = new JLabel("", 0);
    private final JLabel receivedEventLabel = new JLabel("", 0);
    private final JLabel receivedConnectionlabel = new JLabel("", 0);
    private volatile long lastReceivedConnection = System.currentTimeMillis();
    private final Thread connectionThread;
    private final Icon pausedIcon = new ImageIcon(ChainsawIcons.PAUSE);
    private final Icon netConnectIcon = new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT);
    private final NumberFormat nf = NumberFormat.getNumberInstance();
    private final Border statusBarComponentBorder = BorderFactory.createLineBorder(this.statusMsg.getBackground().darker());
    private final LogUI logUI;

    public ChainsawStatusBar(LogUI logUI) {
        this.setLayout(new GridBagLayout());
        this.logUI = logUI;
        this.nf.setMaximumFractionDigits(0);
        this.nf.setMinimumFractionDigits(0);
        this.nf.setGroupingUsed(false);
        JPanel statusMsgPanel = new JPanel(new FlowLayout(0, 2, 2));
        statusMsgPanel.add(this.statusMsg);
        statusMsgPanel.setBorder(this.statusBarComponentBorder);
        this.pausedLabel.setBorder(this.statusBarComponentBorder);
        this.pausedLabel.setMinimumSize(new Dimension(this.pausedIcon.getIconWidth(), this.pausedIcon.getIconHeight()));
        this.pausedLabel.setToolTipText("Shows whether the current Log panel is paused or not");
        this.receivedEventLabel.setBorder(this.statusBarComponentBorder);
        this.receivedEventLabel.setToolTipText("Indicates whether Chainsaw is receiving events, and how fast it is processing them");
        this.receivedEventLabel.setMinimumSize(new Dimension(this.receivedEventLabel.getFontMetrics(this.receivedEventLabel.getFont()).stringWidth("99999999999.9/s") + 5, (int)this.receivedEventLabel.getPreferredSize().getHeight()));
        this.eventCountLabel.setBorder(this.statusBarComponentBorder);
        this.eventCountLabel.setToolTipText("<# viewable events>:<# total events>");
        this.eventCountLabel.setMinimumSize(new Dimension(this.eventCountLabel.getFontMetrics(this.eventCountLabel.getFont()).stringWidth("Filtered/Total: 999999999999:999999999999") + 5, (int)this.eventCountLabel.getPreferredSize().getHeight()));
        this.searchMatchLabel.setBorder(this.statusBarComponentBorder);
        this.searchMatchLabel.setToolTipText("<# viewable events>:<# total events>");
        this.searchMatchLabel.setMinimumSize(new Dimension(this.searchMatchLabel.getFontMetrics(this.eventCountLabel.getFont()).stringWidth("Find matches: 999999999999") + 5, (int)this.searchMatchLabel.getPreferredSize().getHeight()));
        this.receivedConnectionlabel.setBorder(this.statusBarComponentBorder);
        this.receivedConnectionlabel.setToolTipText("Indicates whether Chainsaw has received a remote connection");
        this.receivedConnectionlabel.setMinimumSize(new Dimension(this.netConnectIcon.getIconWidth() + 4, (int)this.receivedConnectionlabel.getPreferredSize().getHeight()));
        this.lineSelectionLabel.setBorder(this.statusBarComponentBorder);
        this.lineSelectionLabel.setMinimumSize(new Dimension(this.lineSelectionLabel.getFontMetrics(this.lineSelectionLabel.getFont()).stringWidth("999999999"), (int)this.lineSelectionLabel.getPreferredSize().getHeight()));
        this.lineSelectionLabel.setToolTipText("The current line # selected");
        JComponent[] toFix = new JComponent[]{this.searchMatchLabel, this.eventCountLabel, this.receivedConnectionlabel, this.lineSelectionLabel, this.receivedEventLabel, this.pausedLabel};
        for (int i = 0; i < toFix.length; ++i) {
            toFix[i].setPreferredSize(toFix[i].getMinimumSize());
            toFix[i].setMaximumSize(toFix[i].getMinimumSize());
        }
        this.statusMsg.setMinimumSize(this.pausedLabel.getPreferredSize());
        this.statusMsg.setToolTipText("Shows messages from Chainsaw");
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipadx = 2;
        c.ipady = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 17;
        this.add((Component)statusMsgPanel, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 1;
        this.add((Component)this.receivedConnectionlabel, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 2;
        this.add((Component)this.lineSelectionLabel, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 3;
        this.add((Component)this.searchMatchLabel, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 4;
        this.add((Component)this.eventCountLabel, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 5;
        this.add((Component)this.receivedEventLabel, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 6;
        this.add((Component)this.pausedLabel, c);
        this.connectionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Icon icon = null;
                    if (System.currentTimeMillis() - ChainsawStatusBar.this.lastReceivedConnection < 5000L) {
                        icon = ChainsawStatusBar.this.netConnectIcon;
                    }
                    final Icon theIcon = icon;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChainsawStatusBar.this.receivedConnectionlabel.setIcon(theIcon);
                        }
                    });
                }
            }
        });
        this.connectionThread.start();
    }

    void setDataRate(final double dataRate) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChainsawStatusBar.this.receivedEventLabel.setText(ChainsawStatusBar.this.nf.format(dataRate) + "/s");
            }
        });
    }

    void remoteConnectionReceived(String source) {
        this.lastReceivedConnection = System.currentTimeMillis();
        MessageCenter.getInstance().getLogger().info((Object)("Connection received from " + source));
        this.connectionThread.interrupt();
    }

    void setPaused(final boolean isPaused, String tabName) {
        if (tabName.equals(this.logUI.getActiveTabName())) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ChainsawStatusBar.this.pausedLabel.setIcon(isPaused ? ChainsawStatusBar.this.pausedIcon : null);
                    ChainsawStatusBar.this.pausedLabel.setToolTipText(isPaused ? "This Log panel is currently paused" : "This Log panel is not paused");
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    void setSelectedLine(final int selectedLine, final int lineCount, final int total, String tabName) {
        if (tabName.equals(this.logUI.getActiveTabName())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChainsawStatusBar.this.lineSelectionLabel.setText(selectedLine + "");
                    ChainsawStatusBar.this.eventCountLabel.setText("Filtered/Total: " + lineCount + ":" + total);
                }
            });
        }
    }

    void setSearchMatchCount(int searchMatchCount, String tabName) {
        if (tabName.equals(this.logUI.getActiveTabName())) {
            if (searchMatchCount == 0) {
                this.searchMatchLabel.setText("");
            } else {
                this.searchMatchLabel.setText("Find matches: " + searchMatchCount);
            }
        }
    }

    void setNothingSelected() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChainsawStatusBar.this.lineSelectionLabel.setText("");
            }
        });
    }

    void clear() {
        this.setMessage(DEFAULT_MSG);
        this.setNothingSelected();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChainsawStatusBar.this.receivedEventLabel.setText("");
            }
        });
    }

    public void setMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChainsawStatusBar.this.statusMsg.setText(" " + msg);
            }
        });
    }
}

