/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReceiversHelper {
    private static final ReceiversHelper instance = new ReceiversHelper();
    private final Logger logger = LogManager.getLogger(ReceiversHelper.class);
    private List receiverClassList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiversHelper() {
        URL url = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/known.receivers");
        if (url == null) {
            this.logger.warn((Object)"Failed to locate known.receivers file");
            return;
        }
        BufferedReader stream = null;
        try {
            String line;
            stream = new LineNumberReader(new InputStreamReader(url.openStream()));
            ClassLoader classLoader = PluginClassLoaderFactory.getInstance().getClassLoader();
            while ((line = ((LineNumberReader)stream).readLine()) != null) {
                try {
                    if (line.startsWith("#") || line.length() == 0) continue;
                    Class<?> receiverClass = classLoader.loadClass(line);
                    this.receiverClassList.add(receiverClass);
                    this.logger.debug((Object)("Located known Receiver class " + receiverClass.getName()));
                }
                catch (ClassNotFoundException e) {
                    this.logger.warn((Object)("Failed to locate Receiver class:" + line));
                }
                catch (NoClassDefFoundError e) {
                    this.logger.error((Object)("Failed to locate Receiver class:" + line + ", looks like a dependent class is missing from the classpath"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public static ReceiversHelper getInstance() {
        return instance;
    }

    public List getKnownReceiverClasses() {
        return Collections.unmodifiableList(this.receiverClassList);
    }

    public void saveReceiverConfiguration(File file) {
        LoggerRepository repo = LogManager.getLoggerRepository();
        PluginRegistry pluginRegistry = ((LoggerRepositoryEx)repo).getPluginRegistry();
        List fullPluginList = pluginRegistry.getPlugins();
        ArrayList<Plugin> pluginList = new ArrayList<Plugin>();
        for (Plugin thisPlugin : fullPluginList) {
            if (!(thisPlugin instanceof Receiver)) continue;
            pluginList.add(thisPlugin);
        }
        try {
            if (pluginList.size() > 0) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element rootElement = document.createElementNS("http://jakarta.apache.org/log4j/", "configuration");
                rootElement.setPrefix("log4j");
                rootElement.setAttribute("xmlns:log4j", "http://jakarta.apache.org/log4j/");
                rootElement.setAttribute("debug", "true");
                for (int i = 0; i < pluginList.size(); ++i) {
                    if (!(pluginList.get(i) instanceof Receiver)) continue;
                    Receiver receiver = (Receiver)pluginList.get(i);
                    Element pluginElement = document.createElement("plugin");
                    pluginElement.setAttribute("name", receiver.getName());
                    pluginElement.setAttribute("class", receiver.getClass().getName());
                    BeanInfo beanInfo = Introspector.getBeanInfo(receiver.getClass());
                    ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(Arrays.asList(beanInfo.getPropertyDescriptors()));
                    for (int j = 0; j < list.size(); ++j) {
                        Object o;
                        PropertyDescriptor d = (PropertyDescriptor)list.get(j);
                        if (d.getReadMethod().getName().equals("getLoggerRepository") || (o = d.getReadMethod().invoke((Object)receiver, new Object[0])) == null) continue;
                        Element paramElement = document.createElement("param");
                        paramElement.setAttribute("name", d.getName());
                        paramElement.setAttribute("value", o.toString());
                        pluginElement.appendChild(paramElement);
                    }
                    rootElement.appendChild(pluginElement);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                DOMSource source = new DOMSource(rootElement);
                FileOutputStream stream = new FileOutputStream(file);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

