/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.spi.CopyOnWrite;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

public class ContextDataInjectorFactory {
    public static ContextDataInjector createInjector() {
        try {
            Class<? extends ContextDataInjector> injector = ((CoreProperties.LogEventProperties)PropertyEnvironment.getGlobal().getProperty(CoreProperties.LogEventProperties.class)).contextData().injector();
            if (injector != null) {
                return (ContextDataInjector)LoaderUtil.newInstanceOf(injector);
            }
        }
        catch (ReflectiveOperationException e) {
            StatusLogger.getLogger().warn("Could not create ContextDataInjector: {}", (Object)e.getMessage(), (Object)e);
        }
        return ContextDataInjectorFactory.createDefaultInjector();
    }

    private static ContextDataInjector createDefaultInjector() {
        ReadOnlyThreadContextMap threadContextMap = ThreadContext.getThreadContextMap();
        if (threadContextMap == null) {
            return new ThreadContextDataInjector.ForDefaultThreadContextMap();
        }
        if (threadContextMap instanceof CopyOnWrite) {
            return new ThreadContextDataInjector.ForCopyOnWriteThreadContextMap();
        }
        return new ThreadContextDataInjector.ForGarbageFreeThreadContextMap();
    }
}

