/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.core.common.XThreadInputStream;

public class CommonsHTTPSender
extends BasicHandler {
    public static final String HTTPCLIENT_PROPERTY = "ManifoldCF_HttpClient";
    protected static Log log = LogFactory.getLog((String)CommonsHTTPSender.class.getName());
    protected CommonsHTTPClientProperties clientProperties = CommonsHTTPClientPropertiesFactory.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"enter00", (String)"CommonsHTTPSender::invoke"));
        }
        try {
            HttpGet method;
            String webMethod;
            URL targetURL = new URL(msgContext.getStrProp("transport.url"));
            HttpClient httpClient = (HttpClient)msgContext.getProperty(HTTPCLIENT_PROPERTY);
            boolean posting = true;
            if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (webMethod = msgContext.getStrProp("soap12.webmethod")) != null) {
                posting = webMethod.equals("POST");
            }
            boolean http10 = false;
            String httpVersion = msgContext.getStrProp("axis.transport.version");
            if (httpVersion != null && httpVersion.equals(HTTPConstants.HEADER_PROTOCOL_V10)) {
                http10 = true;
            }
            if (posting) {
                HttpPost postMethod = new HttpPost(targetURL.toString());
                Message reqMessage = msgContext.getRequestMessage();
                boolean httpChunkStream = CommonsHTTPSender.addContextInfo(postMethod, msgContext);
                MessageRequestEntity requestEntity = null;
                requestEntity = new MessageRequestEntity(reqMessage, httpChunkStream, http10 || !httpChunkStream);
                postMethod.setEntity((HttpEntity)requestEntity);
                method = postMethod;
            } else {
                method = new HttpGet(targetURL.toString());
            }
            BackgroundHTTPThread methodThread = new BackgroundHTTPThread(httpClient, (HttpRequestBase)method);
            methodThread.start();
            try {
                int returnCode = methodThread.getResponseCode();
                String contentType = CommonsHTTPSender.getHeader(methodThread, "Content-Type");
                String contentLocation = CommonsHTTPSender.getHeader(methodThread, "Content-Location");
                String contentLength = CommonsHTTPSender.getHeader(methodThread, "Content-Length");
                if (!(returnCode > 199 && returnCode < 300 || msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || contentType != null && !contentType.equals("text/html") && returnCode > 499 && returnCode < 600)) {
                    String statusMessage = methodThread.getResponseStatus();
                    AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                    fault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + returnCode), (String)CommonsHTTPSender.getResponseBodyAsString(methodThread)));
                    fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(returnCode));
                    throw fault;
                }
                String contentEncoding = methodThread.getFirstHeader("Content-Encoding");
                if (contentEncoding != null) {
                    AxisFault fault = new AxisFault("HTTP", "unsupported content-encoding of '" + contentEncoding + "' found", null, null);
                    throw fault;
                }
                Map<String, List<String>> responseHeaders = methodThread.getResponseHeaders();
                InputStream dataStream = methodThread.getSafeInputStream();
                Message outMsg = new Message((Object)new BackgroundInputStream(methodThread, dataStream), false, contentType, contentLocation);
                MimeHeaders responseMimeHeaders = outMsg.getMimeHeaders();
                for (String name : responseHeaders.keySet()) {
                    List<String> values = responseHeaders.get(name);
                    for (String value : values) {
                        responseMimeHeaders.addHeader(name, value);
                    }
                }
                outMsg.setMessageType("response");
                msgContext.setResponseMessage(outMsg);
                methodThread = null;
            }
            finally {
                if (methodThread != null) {
                    methodThread.abort();
                    methodThread.finishUp();
                }
            }
        }
        catch (AxisFault af) {
            log.debug((Object)af);
            throw af;
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault((Exception)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"exit00", (String)"CommonsHTTPSender::invoke"));
        }
    }

    private static boolean addContextInfo(HttpPost method, MessageContext msgContext) throws AxisFault {
        Message msg;
        String action;
        boolean httpChunkStream = false;
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if ((msg = msgContext.getRequestMessage()) != null) {
            MimeHeaders mimeHeaders = msg.getMimeHeaders();
            if (mimeHeaders != null) {
                Iterator i = mimeHeaders.getAllHeaders();
                while (i.hasNext()) {
                    MimeHeader mimeHeader = (MimeHeader)i.next();
                    method.addHeader(mimeHeader.getName(), mimeHeader.getValue());
                }
            }
            method.setHeader((Header)new BasicHeader("Content-Type", msg.getContentType(msgContext.getSOAPConstants())));
        }
        method.setHeader((Header)new BasicHeader("Accept", "*/*"));
        method.setHeader((Header)new BasicHeader("SOAPAction", "\"" + action + "\""));
        method.setHeader((Header)new BasicHeader("User-Agent", Messages.getMessage((String)"axisUserAgent")));
        Hashtable userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers");
        if (userHeaderTable != null) {
            for (Map.Entry me : userHeaderTable.entrySet()) {
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                String value = me.getValue().toString().trim();
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                    String val = me.getValue().toString();
                    if (null == val) continue;
                    httpChunkStream = JavaUtils.isTrue((String)val);
                    continue;
                }
                method.addHeader(key, value);
            }
        }
        return httpChunkStream;
    }

    private static String getHeader(BackgroundHTTPThread methodThread, String headerName) throws IOException, InterruptedException, HttpException {
        String header = methodThread.getFirstHeader(headerName);
        return header == null ? null : header.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResponseBodyAsString(BackgroundHTTPThread methodThread) throws IOException, InterruptedException, HttpException {
        InputStream is = methodThread.getSafeInputStream();
        if (is != null) {
            try {
                Charset charSet = methodThread.getCharSet();
                if (charSet == null) {
                    charSet = StandardCharsets.UTF_8;
                }
                char[] buffer = new char[65536];
                InputStreamReader r = new InputStreamReader(is, charSet);
                StringWriter w = new StringWriter();
                try {
                    int amt;
                    while ((amt = r.read(buffer)) != -1) {
                        ((Writer)w).write(buffer, 0, amt);
                    }
                }
                finally {
                    ((Writer)w).flush();
                }
                String string = ((Object)w).toString();
                return string;
            }
            finally {
                is.close();
            }
        }
        return "";
    }

    protected static class BackgroundHTTPThread
    extends Thread {
        protected final HttpClient httpClient;
        protected final HttpRequestBase executeMethod;
        protected HttpResponse response = null;
        protected Throwable responseException = null;
        protected XThreadInputStream threadStream = null;
        protected InputStream bodyStream = null;
        protected Charset charSet = null;
        protected boolean streamCreated = false;
        protected Throwable streamException = null;
        protected boolean abortThread = false;
        protected Throwable shutdownException = null;
        protected Throwable generalException = null;

        public BackgroundHTTPThread(HttpClient httpClient, HttpRequestBase executeMethod) {
            this.setDaemon(true);
            this.httpClient = httpClient;
            this.executeMethod = executeMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    BackgroundHTTPThread backgroundHTTPThread = this;
                    synchronized (backgroundHTTPThread) {
                        if (!this.abortThread) {
                            try {
                                this.response = this.httpClient.execute((HttpUriRequest)this.executeMethod);
                            }
                            catch (SocketTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (ConnectTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (InterruptedIOException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                this.responseException = e;
                            }
                            this.notifyAll();
                        }
                    }
                    if (this.responseException == null) {
                        backgroundHTTPThread = this;
                        synchronized (backgroundHTTPThread) {
                            if (!this.abortThread) {
                                try {
                                    HttpEntity entity = this.response.getEntity();
                                    this.bodyStream = entity.getContent();
                                    if (this.bodyStream != null) {
                                        this.threadStream = new XThreadInputStream(this.bodyStream);
                                        try {
                                            ContentType ct = ContentType.get((HttpEntity)entity);
                                            this.charSet = ct == null ? null : ct.getCharset();
                                        }
                                        catch (ParseException e) {
                                            this.charSet = null;
                                        }
                                    }
                                    this.streamCreated = true;
                                }
                                catch (SocketTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (ConnectTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (InterruptedIOException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    this.streamException = e;
                                }
                                this.notifyAll();
                            }
                        }
                    }
                    if (this.responseException == null && this.streamException == null && this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                finally {
                    if (this.bodyStream != null) {
                        try {
                            this.bodyStream.close();
                        }
                        catch (IOException e) {}
                        this.bodyStream = null;
                    }
                    BackgroundHTTPThread e = this;
                    synchronized (e) {
                        try {
                            this.executeMethod.abort();
                        }
                        catch (Throwable e2) {
                            this.shutdownException = e2;
                        }
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable e) {
                this.generalException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getResponseCode() throws InterruptedException, IOException, HttpException {
            while (true) {
                BackgroundHTTPThread backgroundHTTPThread = this;
                synchronized (backgroundHTTPThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        return this.response.getStatusLine().getStatusCode();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getResponseStatus() throws InterruptedException, IOException, HttpException {
            while (true) {
                BackgroundHTTPThread backgroundHTTPThread = this;
                synchronized (backgroundHTTPThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        return this.response.getStatusLine().toString();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, List<String>> getResponseHeaders() throws InterruptedException, IOException, HttpException {
            while (true) {
                BackgroundHTTPThread backgroundHTTPThread = this;
                synchronized (backgroundHTTPThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        Header[] headers = this.response.getAllHeaders();
                        HashMap<String, List<String>> rval = new HashMap<String, List<String>>();
                        int i = 0;
                        while (i < headers.length) {
                            Header h = headers[i++];
                            String name = h.getName();
                            String value = h.getValue();
                            ArrayList<String> values = (ArrayList<String>)rval.get(name);
                            if (values == null) {
                                values = new ArrayList<String>();
                                rval.put(name, values);
                            }
                            values.add(value);
                        }
                        return rval;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFirstHeader(String headerName) throws InterruptedException, IOException, HttpException {
            while (true) {
                BackgroundHTTPThread backgroundHTTPThread = this;
                synchronized (backgroundHTTPThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        Header h = this.response.getFirstHeader(headerName);
                        if (h == null) {
                            return null;
                        }
                        return h.getValue();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException, HttpException {
            while (true) {
                BackgroundHTTPThread backgroundHTTPThread = this;
                synchronized (backgroundHTTPThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Charset getCharSet() throws InterruptedException, IOException, HttpException {
            while (true) {
                BackgroundHTTPThread backgroundHTTPThread = this;
                synchronized (backgroundHTTPThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting charset");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.charSet;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            BackgroundHTTPThread backgroundHTTPThread = this;
            synchronized (backgroundHTTPThread) {
                if (this.streamCreated && this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
        }

        public void finishUp() throws InterruptedException {
            this.join();
        }

        protected synchronized void checkException(Throwable exception) throws IOException, HttpException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof HttpException) {
                    throw (HttpException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }
    }

    private static class BackgroundInputStream
    extends InputStream {
        private BackgroundHTTPThread methodThread = null;
        private InputStream xThreadInputStream = null;

        public BackgroundInputStream(BackgroundHTTPThread methodThread, InputStream xThreadInputStream) {
            this.methodThread = methodThread;
            this.xThreadInputStream = xThreadInputStream;
        }

        @Override
        public int available() throws IOException {
            if (this.xThreadInputStream != null) {
                return this.xThreadInputStream.available();
            }
            return super.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.xThreadInputStream != null) {
                    this.xThreadInputStream.close();
                    this.xThreadInputStream = null;
                }
            }
            finally {
                if (this.methodThread != null) {
                    this.methodThread.abort();
                    try {
                        this.methodThread.finishUp();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException(e.getMessage());
                    }
                    this.methodThread = null;
                }
            }
        }

        @Override
        public void mark(int readlimit) {
            if (this.xThreadInputStream != null) {
                this.xThreadInputStream.mark(readlimit);
            } else {
                super.mark(readlimit);
            }
        }

        @Override
        public void reset() throws IOException {
            if (this.xThreadInputStream != null) {
                this.xThreadInputStream.reset();
            } else {
                super.reset();
            }
        }

        @Override
        public boolean markSupported() {
            if (this.xThreadInputStream != null) {
                return this.xThreadInputStream.markSupported();
            }
            return super.markSupported();
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.xThreadInputStream != null) {
                return this.xThreadInputStream.skip(n);
            }
            return super.skip(n);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.xThreadInputStream != null) {
                return this.xThreadInputStream.read(b, off, len);
            }
            return super.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.xThreadInputStream != null) {
                return this.xThreadInputStream.read(b);
            }
            return super.read(b);
        }

        @Override
        public int read() throws IOException {
            if (this.xThreadInputStream != null) {
                return this.xThreadInputStream.read();
            }
            return -1;
        }
    }

    private static class MessageRequestEntity
    implements HttpEntity {
        private final Message message;
        private final boolean httpChunkStream;
        private final boolean contentLengthNeeded;

        public MessageRequestEntity(Message message, boolean httpChunkStream, boolean contentLengthNeeded) {
            this.message = message;
            this.httpChunkStream = httpChunkStream;
            this.contentLengthNeeded = contentLengthNeeded;
        }

        public boolean isChunked() {
            return this.httpChunkStream;
        }

        @Deprecated
        public void consumeContent() throws IOException {
            EntityUtils.consume((HttpEntity)this);
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isStreaming() {
            return false;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return null;
        }

        public void writeTo(OutputStream out) throws IOException {
            try {
                this.message.writeTo(out);
            }
            catch (SOAPException e) {
                throw new IOException(e.getMessage());
            }
        }

        public long getContentLength() {
            if (this.contentLengthNeeded) {
                try {
                    return this.message.getContentLength();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return -1L;
        }

        public Header getContentType() {
            return null;
        }

        public Header getContentEncoding() {
            return null;
        }
    }
}

