/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LinkParseState;

public class FormParseState
extends LinkParseState {
    protected static final int FORMPARSESTATE_NORMAL = 0;
    protected static final int FORMPARSESTATE_IN_FORM = 1;
    protected static final int FORMPARSESTATE_IN_SELECT = 2;
    protected static final int FORMPARSESTATE_IN_TEXTAREA = 3;
    protected static final int FORMPARSESTATE_IN_OPTION = 4;
    protected int formParseState = 0;
    protected String selectName = null;
    protected String selectMultiple = null;
    protected String optionValue = null;
    protected String optionSelected = null;
    protected StringBuilder optionValueText = null;

    public FormParseState(IHTMLHandler handler) {
        super(handler);
    }

    @Override
    protected boolean noteNonscriptTag(String tagName, Map<String, String> attributes) throws ManifoldCFException {
        if (super.noteNonscriptTag(tagName, attributes)) {
            return true;
        }
        switch (this.formParseState) {
            case 0: {
                if (!tagName.equals("form")) break;
                this.formParseState = 1;
                this.handler.noteFormStart(attributes);
                break;
            }
            case 1: {
                if (tagName.equals("input")) {
                    String type = attributes.get("type");
                    if (type != null && (type.toLowerCase().equals("button") || type.toLowerCase().equals("reset") || type.toLowerCase().equals("image"))) break;
                    this.handler.noteFormInput(attributes);
                    break;
                }
                if (tagName.equals("select")) {
                    this.selectName = attributes.get("name");
                    this.selectMultiple = attributes.get("multiple");
                    this.formParseState = 2;
                    break;
                }
                if (tagName.equals("textarea")) {
                    this.formParseState = 3;
                    HashMap<String, String> textareaMap = new HashMap<String, String>();
                    textareaMap.put("type", "textarea");
                    textareaMap.put("value", "");
                    this.handler.noteFormInput(textareaMap);
                    break;
                }
                if (tagName.equals("button")) {
                    String type = attributes.get("type");
                    if (type != null && !type.toLowerCase().equals("submit")) break;
                    this.handler.noteFormInput(attributes);
                    break;
                }
                if (!tagName.equals("isindex")) break;
                HashMap<String, String> indexMap = new HashMap<String, String>();
                indexMap.put("type", "text");
                break;
            }
            case 2: {
                if (!tagName.equals("option")) break;
                this.optionValue = attributes.get("value");
                this.optionSelected = attributes.get("selected");
                this.formParseState = 4;
                if (this.optionValue != null) {
                    HashMap<String, String> optionMap = new HashMap<String, String>();
                    optionMap.put("type", "select");
                    optionMap.put("name", this.selectName);
                    optionMap.put("multiple", this.selectMultiple);
                    optionMap.put("value", this.optionValue);
                    optionMap.put("selected", this.optionSelected);
                    this.handler.noteFormInput(optionMap);
                    break;
                }
                this.optionValueText = new StringBuilder();
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new ManifoldCFException("Unknown form parse state: " + Integer.toString(this.formParseState));
            }
        }
        return false;
    }

    @Override
    protected boolean noteNonscriptEndTag(String tagName) throws ManifoldCFException {
        if (super.noteNonscriptEndTag(tagName)) {
            return true;
        }
        switch (this.formParseState) {
            case 0: {
                break;
            }
            case 1: {
                if (!tagName.equals("form")) break;
                this.handler.noteFormEnd();
                this.formParseState = 0;
                break;
            }
            case 2: {
                this.formParseState = 1;
                this.selectName = null;
                this.selectMultiple = null;
                break;
            }
            case 4: {
                if (!tagName.equals("option")) break;
                if (this.optionValueText != null) {
                    HashMap<String, String> optionMap = new HashMap<String, String>();
                    optionMap.put("type", "select");
                    optionMap.put("name", this.selectName);
                    optionMap.put("multiple", this.selectMultiple);
                    optionMap.put("value", this.optionValueText.toString());
                    optionMap.put("selected", this.optionSelected);
                    this.handler.noteFormInput(optionMap);
                }
                this.formParseState = 2;
                this.optionSelected = null;
                this.optionValue = null;
                this.optionValueText = null;
                break;
            }
            case 3: {
                if (!tagName.equals("textarea")) break;
                this.formParseState = 1;
                break;
            }
            default: {
                throw new ManifoldCFException("Unknown form parse state: " + Integer.toString(this.formParseState));
            }
        }
        return false;
    }

    protected boolean noteNormalCharacter(char thisChar) throws ManifoldCFException {
        if (super.noteNormalCharacter(thisChar)) {
            return true;
        }
        if (this.formParseState == 4) {
            if (this.optionValueText != null) {
                this.optionValueText.append(thisChar);
            }
        } else {
            this.handler.noteTextCharacter(thisChar);
        }
        return false;
    }
}

