/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JobStartThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: JobStartThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final String processID;

    public JobStartThread(String processID) throws ManifoldCFException {
        this.processID = processID;
        this.setName("Job start thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(threadContext);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (Logging.threads.isDebugEnabled()) {
                        Logging.threads.debug((Object)("Job start thread - checking for jobs to start at " + new Long(currentTime).toString()));
                    }
                    ArrayList<Long> unwaitJobs = new ArrayList<Long>();
                    jobManager.startJobs(currentTime, unwaitJobs);
                    int k = 0;
                    while (k < unwaitJobs.size()) {
                        Long jobID = (Long)unwaitJobs.get(k++);
                        IJobDescription desc = jobManager.load(jobID);
                        connectionManager.recordHistory(desc.getConnectionName(), null, "job unwait", null, desc.getID().toString() + "(" + desc.getDescription() + ")", null, null, null);
                    }
                    ArrayList<Long> waitJobs = new ArrayList<Long>();
                    jobManager.waitJobs(currentTime, waitJobs);
                    k = 0;
                    while (k < waitJobs.size()) {
                        Long jobID = (Long)waitJobs.get(k++);
                        IJobDescription desc = jobManager.load(jobID);
                        connectionManager.recordHistory(desc.getConnectionName(), null, "job wait", null, desc.getID().toString() + "(" + desc.getDescription() + ")", null, null, null);
                    }
                    ManifoldCF.sleep((long)10000L);
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("Job start thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                }
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("JobStartThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

