/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.fuzzyml;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.manifoldcf.core.fuzzyml.CharacterBuffer;

public class PrefixedReader
extends Reader {
    protected final CharacterBuffer chars;
    protected final Reader remainderStream;
    protected int charPosition = 0;
    protected int charMax;

    public PrefixedReader(CharacterBuffer chars, Reader remainderStream) {
        this.chars = chars;
        this.remainderStream = remainderStream;
        this.charMax = chars.size();
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        if (this.charPosition < this.charMax) {
            return super.read(target);
        }
        return this.remainderStream.read(target);
    }

    @Override
    public int read() throws IOException {
        if (this.charPosition < this.charMax) {
            return super.read();
        }
        return this.remainderStream.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (this.charPosition < this.charMax) {
            return super.read(cbuf);
        }
        return this.remainderStream.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int amt = 0;
        while (this.charPosition < this.charMax) {
            cbuf[off++] = this.chars.readChar(this.charPosition++);
            --len;
            ++amt;
        }
        if (len > 0) {
            int rem = this.remainderStream.read(cbuf, off, len);
            if (rem == -1) {
                if (amt > 0) {
                    return amt;
                }
                return rem;
            }
            amt += rem;
        }
        return amt;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.charPosition < this.charMax) {
            return super.skip(n);
        }
        return this.remainderStream.skip(n);
    }

    @Override
    public void close() throws IOException {
    }
}

