/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.hdfs.HDFSOutputConfig;
import org.apache.manifoldcf.agents.output.hdfs.HDFSOutputParam;
import org.apache.manifoldcf.agents.output.hdfs.HDFSOutputSpecs;
import org.apache.manifoldcf.agents.output.hdfs.HDFSSession;
import org.apache.manifoldcf.agents.output.hdfs.Messages;
import org.apache.manifoldcf.agents.output.hdfs.ParameterEnum;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.json.JSONException;

public class HDFSOutputConnector
extends BaseOutputConnector {
    public static final String _rcsid = "@(#)$Id: FileOutputConnector.java 988245 2010-08-23 18:39:35Z minoru $";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    protected static final String[] activitiesList = new String[]{"document ingest", "document deletion"};
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_CONFIGURATION_HTML = "editConfiguration.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_HTML = "editSpecification.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    protected String nameNodeProtocol = null;
    protected String nameNodeHost = null;
    protected String nameNodePort = null;
    protected String user = null;
    protected HDFSSession session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.nameNodeProtocol = configParams.getParameter(ParameterEnum.namenodeprotocol.name());
        if (this.nameNodeProtocol == null) {
            this.nameNodeProtocol = "hdfs";
        }
        this.nameNodeHost = configParams.getParameter(ParameterEnum.namenodehost.name());
        this.nameNodePort = configParams.getParameter(ParameterEnum.namenodeport.name());
        this.user = configParams.getParameter(ParameterEnum.user.name());
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void disconnect() throws ManifoldCFException {
        this.closeSession();
        this.nameNodeProtocol = null;
        this.nameNodeHost = null;
        this.nameNodePort = null;
        this.user = null;
        super.disconnect();
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSession() throws ManifoldCFException {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                Logging.agents.warn((Object)("HDFS: Error closing connection: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.session = null;
                this.lastSessionFetch = -1L;
            }
        }
    }

    protected HDFSSession getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (this.nameNodeProtocol == null) {
                this.nameNodeProtocol = "hdfs";
            }
            if (this.nameNodeHost == null) {
                throw new ManifoldCFException("Namenodehost must be specified");
            }
            if (this.nameNodePort == null) {
                throw new ManifoldCFException("Namenodeport must be specified");
            }
            if (this.user == null) {
                throw new ManifoldCFException("User must be specified");
            }
            String nameNode = this.nameNodeProtocol + "://" + this.nameNodeHost + ":" + this.nameNodePort;
            GetSessionThread t = new GetSessionThread(nameNode, this.user);
            try {
                t.start();
                t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (SocketTimeoutException e) {
                HDFSOutputConnector.handleIOException(e);
            }
            catch (InterruptedIOException e) {
                t.interrupt();
                HDFSOutputConnector.handleIOException(e);
            }
            catch (URISyntaxException e) {
                HDFSOutputConnector.handleURISyntaxException(e);
            }
            catch (IOException e) {
                HDFSOutputConnector.handleIOException(e);
            }
            this.session = t.getResult();
        }
        this.lastSessionFetch = System.currentTimeMillis();
        return this.session;
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        HDFSOutputSpecs specs = new HDFSOutputSpecs((ConfigurationNode)this.getSpecNode(spec));
        return new VersionContext(specs.toJson().toString(), this.params, spec);
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        HDFSOutputSpecs specs = new HDFSOutputSpecs((ConfigurationNode)this.getSpecNode(pipelineDescription.getSpecification()));
        try {
            StringBuffer strBuff = new StringBuffer();
            if (specs.getRootPath() != null) {
                strBuff.append(specs.getRootPath());
            }
            strBuff.append("/");
            strBuff.append(this.documentURItoFilePath(documentURI));
            Path path = new Path(strBuff.toString());
            Long startTime = new Long(System.currentTimeMillis());
            this.createFile(path, document.getBinaryStream(), activities, documentURI);
            activities.recordActivity(startTime, INGEST_ACTIVITY, new Long(document.getBinaryLength()), documentURI, "OK", null);
            return 0;
        }
        catch (URISyntaxException e) {
            activities.recordActivity(null, INGEST_ACTIVITY, new Long(document.getBinaryLength()), documentURI, e.getClass().getSimpleName().toUpperCase(Locale.ROOT), "Failed to write document due to: " + e.getMessage());
            HDFSOutputConnector.handleURISyntaxException(e);
            return 1;
        }
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        try {
            HDFSOutputSpecs specs = new HDFSOutputSpecs(outputDescription);
            StringBuffer strBuff = new StringBuffer();
            if (specs.getRootPath() != null) {
                strBuff.append(specs.getRootPath());
            }
            strBuff.append("/");
            strBuff.append(this.documentURItoFilePath(documentURI));
            Path path = new Path(strBuff.toString());
            Long startTime = new Long(System.currentTimeMillis());
            this.deleteFile(path, activities, documentURI);
            activities.recordActivity(startTime, REMOVE_ACTIVITY, null, documentURI, "OK", null);
        }
        catch (JSONException e) {
            activities.recordActivity(null, REMOVE_ACTIVITY, null, documentURI, ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT), "Failed to delete document due to: " + e.getMessage());
            HDFSOutputConnector.handleJSONException(e);
        }
        catch (URISyntaxException e) {
            activities.recordActivity(null, REMOVE_ACTIVITY, null, documentURI, e.getClass().getSimpleName().toUpperCase(Locale.ROOT), "Failed to delete document due to: " + e.getMessage());
            HDFSOutputConnector.handleURISyntaxException(e);
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        super.outputConfigurationHeader(threadContext, out, locale, parameters, tabsArray);
        tabsArray.add(Messages.getString(locale, "HDFSOutputConnector.ServerTabName"));
        HDFSOutputConnector.outputResource(EDIT_CONFIGURATION_JS, out, locale, null, null, null, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        super.outputConfigurationBody(threadContext, out, locale, parameters, tabName);
        HDFSOutputConfig config = this.getConfigParameters(parameters);
        HDFSOutputConnector.outputResource(EDIT_CONFIGURATION_HTML, out, locale, config, tabName, null, null);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        HDFSOutputConfig.contextToConfig(variableContext, parameters);
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HDFSOutputConnector.outputResource(VIEW_CONFIGURATION_HTML, out, locale, this.getConfigParameters(parameters), null, null, null);
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        super.outputSpecificationHeader(out, locale, os, connectionSequenceNumber, tabsArray);
        tabsArray.add(Messages.getString(locale, "HDFSOutputConnector.PathTabName"));
        HDFSOutputConnector.outputResource(EDIT_SPECIFICATION_JS, out, locale, null, null, new Integer(connectionSequenceNumber), null);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        super.outputSpecificationBody(out, locale, os, connectionSequenceNumber, actualSequenceNumber, tabName);
        HDFSOutputSpecs specs = this.getSpecParameters(os);
        HDFSOutputConnector.outputResource(EDIT_SPECIFICATION_HTML, out, locale, specs, tabName, new Integer(connectionSequenceNumber), new Integer(actualSequenceNumber));
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        boolean bAdd;
        SpecificationNode specNode = this.getSpecNode(os);
        boolean bl = bAdd = specNode == null;
        if (bAdd) {
            specNode = new SpecificationNode(ParameterEnum.rootpath.name());
        }
        HDFSOutputSpecs.contextToSpecNode(variableContext, (ConfigurationNode)specNode, connectionSequenceNumber);
        if (bAdd) {
            os.addChild(os.getChildCount(), (ConfigurationNode)specNode);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HDFSOutputConnector.outputResource(VIEW_SPECIFICATION_HTML, out, locale, this.getSpecParameters(os), null, new Integer(connectionSequenceNumber), null);
    }

    private final SpecificationNode getSpecNode(Specification os) {
        int l = os.getChildCount();
        for (int i = 0; i < l; ++i) {
            SpecificationNode node = os.getChild(i);
            if (!node.getType().equals(ParameterEnum.rootpath.name())) continue;
            return node;
        }
        return null;
    }

    private final HDFSOutputSpecs getSpecParameters(Specification os) throws ManifoldCFException {
        return new HDFSOutputSpecs((ConfigurationNode)this.getSpecNode(os));
    }

    private final HDFSOutputConfig getConfigParameters(ConfigParams configParams) {
        if (configParams == null) {
            configParams = this.getConfiguration();
        }
        return new HDFSOutputConfig(configParams);
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, HDFSOutputParam params, String tabName, Integer sequenceNumber, Integer actualSequenceNumber) throws ManifoldCFException {
        Map<String, String> paramMap = null;
        if (params != null) {
            paramMap = params.buildMap();
            if (tabName != null) {
                paramMap.put("TabName", tabName);
            }
            if (actualSequenceNumber != null) {
                paramMap.put("SelectedNum", actualSequenceNumber.toString());
            }
        } else {
            paramMap = new HashMap<String, String>();
        }
        if (sequenceNumber != null) {
            paramMap.put("SeqNum", sequenceNumber.toString());
        }
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, true);
    }

    private final String documentURItoFilePath(String documentURI) throws URISyntaxException {
        StringBuffer path = new StringBuffer();
        URI uri = null;
        uri = new URI(documentURI);
        if (uri.getScheme() != null) {
            path.append(uri.getScheme());
            path.append("/");
        }
        if (uri.getHost() != null) {
            path.append(uri.getHost());
            if (uri.getPort() != -1) {
                path.append(":");
                path.append(Integer.toString(uri.getPort()));
            }
            if (uri.getRawPath() != null) {
                if (uri.getRawPath().length() == 0) {
                    path.append("/");
                } else if (uri.getRawPath().equals("/")) {
                    path.append(uri.getRawPath());
                } else {
                    for (String name : uri.getRawPath().split("/")) {
                        if (name == null || name.length() <= 0) continue;
                        path.append("/");
                        path.append(name);
                    }
                }
            }
            if (uri.getRawQuery() != null) {
                path.append("?");
                path.append(uri.getRawQuery());
            }
        } else if (uri.getRawSchemeSpecificPart() != null) {
            for (String name : uri.getRawSchemeSpecificPart().split("/")) {
                if (name == null || name.length() <= 0) continue;
                path.append("/");
                path.append(name);
            }
        }
        if (path.toString().endsWith("/")) {
            path.append(".content");
        }
        return path.toString();
    }

    protected static void handleURISyntaxException(URISyntaxException e) throws ManifoldCFException, ServiceInterruption {
        Logging.agents.error((Object)("Namenode URI is malformed: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("Namenode URI is malformed: " + e.getMessage(), (Throwable)e);
    }

    protected static void handleJSONException(JSONException e) throws ManifoldCFException, ServiceInterruption {
        Logging.agents.error((Object)("JSON parsing error: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("JSON parsing error: " + e.getMessage(), (Throwable)e);
    }

    protected static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        Logging.agents.warn((Object)("HDFS output connection: IO exception: " + e.getMessage()), (Throwable)e);
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    /*
     * Exception decompiling
     */
    protected void createFile(Path path, InputStream input, IOutputAddActivity activities, String documentURI) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void deleteFile(Path path, IOutputRemoveActivity activities, String documentURI) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        CheckConnectionThread t = new CheckConnectionThread(this.getSession());
        try {
            t.start();
            t.finishUp();
            return;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            HDFSOutputConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            HDFSOutputConnector.handleIOException(e);
        }
        catch (IOException e) {
            HDFSOutputConnector.handleIOException(e);
        }
    }

    protected static class GetSessionThread
    extends Thread {
        protected final String nameNode;
        protected final String user;
        protected Throwable exception = null;
        protected HDFSSession session = null;

        public GetSessionThread(String nameNode, String user) {
            this.nameNode = nameNode;
            this.user = user;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session = new HDFSSession(this.nameNode, this.user);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException, URISyntaxException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof URISyntaxException) {
                    throw (URISyntaxException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }

        public HDFSSession getResult() {
            return this.session;
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final HDFSSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(HDFSSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }

    protected static class DeleteFileThread
    extends Thread {
        protected final HDFSSession session;
        protected final Path path;
        protected Throwable exception = null;

        public DeleteFileThread(HDFSSession session, Path path) {
            this.session = session;
            this.path = path;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.deleteFile(this.path);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }

    protected static class CreateFileThread
    extends Thread {
        protected final HDFSSession session;
        protected final Path path;
        protected final InputStream input;
        protected Throwable exception = null;

        public CreateFileThread(HDFSSession session, Path path, InputStream input) {
            this.session = session;
            this.path = path;
            this.input = input;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.createFile(this.path, this.input);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }
}

