/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.sharepoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.sharepoint.Messages;
import org.apache.manifoldcf.authorities.authorities.sharepoint.SPSProxyHelper;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.connectorcommon.common.CommonsHTTPSender;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.util.URLDecoder;
import org.apache.manifoldcf.core.util.URLEncoder;

public class SharePointAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: SharePointAuthority.java 1672741 2015-04-10 20:03:53Z kwright $";
    private ICacheManager cacheManager = null;
    private boolean hasSessionParameters = false;
    private static final long SharePointExpirationInterval = 300000L;
    private boolean isClaimSpace = false;
    private String serverProtocol = null;
    private String serverUrl = null;
    private String fileBaseUrl = null;
    private String serverUserName = null;
    private String password = null;
    private String ntlmDomain = null;
    private String serverName = null;
    private String serverPortString = null;
    private String serverLocation = null;
    private String strippedUserName = null;
    private String encodedServerLocation = null;
    private String keystoreData = null;
    private String proxyHost = null;
    private String proxyPortString = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String proxyDomain = null;
    private String cacheLRUsize = null;
    private String cacheLifetime = null;
    private int serverPort = -1;
    private SPSProxyHelper proxy = null;
    private long sharepointSessionTimeout;
    private long responseLifetime = -1L;
    private int LRUsize = -1;
    private IKeystoreManager keystoreManager = null;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClient httpClient = null;
    private static String currentHost = null;
    protected static StringSet emptyStringSet;

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void connect(ConfigParams configParams) {
        String serverClaimSpace;
        String serverVersion;
        super.connect(configParams);
        this.cacheLifetime = configParams.getParameter("Cache lifetime");
        if (this.cacheLifetime == null) {
            this.cacheLifetime = "1";
        }
        this.cacheLRUsize = configParams.getParameter("Cache LRU size");
        if (this.cacheLRUsize == null) {
            this.cacheLRUsize = "1000";
        }
        if ((serverVersion = configParams.getParameter("serverVersion")) == null) {
            serverVersion = "4.0";
        }
        if ((serverClaimSpace = configParams.getParameter("serverClaimSpace")) == null) {
            serverClaimSpace = "false";
        }
        this.isClaimSpace = serverClaimSpace.equals("true");
        this.serverProtocol = configParams.getParameter("serverProtocol");
        if (this.serverProtocol == null) {
            this.serverProtocol = "http";
        }
        this.serverName = configParams.getParameter("serverName");
        this.serverPortString = configParams.getParameter("serverPort");
        this.serverLocation = configParams.getParameter("serverLocation");
        if (this.serverLocation == null) {
            this.serverLocation = "";
        }
        if (this.serverLocation.endsWith("/")) {
            this.serverLocation = this.serverLocation.substring(0, this.serverLocation.length() - 1);
        }
        if (this.serverLocation.length() > 0 && !this.serverLocation.startsWith("/")) {
            this.serverLocation = "/" + this.serverLocation;
        }
        this.encodedServerLocation = this.serverLocation;
        this.serverLocation = SharePointAuthority.decodePath(this.serverLocation);
        this.serverUserName = configParams.getParameter("userName");
        this.password = configParams.getObfuscatedParameter("password");
        int index = this.serverUserName.indexOf("\\");
        if (index != -1) {
            this.strippedUserName = this.serverUserName.substring(index + 1);
            this.ntlmDomain = this.serverUserName.substring(0, index);
        } else {
            this.strippedUserName = null;
            this.ntlmDomain = null;
        }
        this.proxyHost = this.params.getParameter("proxyHost");
        this.proxyPortString = this.params.getParameter("proxyPort");
        this.proxyUsername = this.params.getParameter("proxyUser");
        this.proxyPassword = this.params.getParameter("proxyPassword");
        this.proxyDomain = this.params.getParameter("proxyDomain");
        this.keystoreData = this.params.getParameter("keystore");
    }

    public String check() throws ManifoldCFException {
        this.getSharePointSession();
        try {
            URL urlServer = new URL(this.serverUrl);
        }
        catch (MalformedURLException e) {
            return "Illegal SharePoint url: " + e.getMessage();
        }
        try {
            this.proxy.checkConnection("/");
        }
        catch (ManifoldCFException e) {
            return e.getMessage();
        }
        return super.check();
    }

    public void poll() throws ManifoldCFException {
        long currentTime = System.currentTimeMillis();
        if (this.proxy != null && System.currentTimeMillis() >= this.sharepointSessionTimeout) {
            this.expireSharePointSession();
        }
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(60000L, TimeUnit.MILLISECONDS);
        }
        super.poll();
    }

    public boolean isConnected() {
        return this.connectionManager != null;
    }

    public void disconnect() throws ManifoldCFException {
        this.cacheLifetime = null;
        this.cacheLRUsize = null;
        this.isClaimSpace = false;
        this.serverUrl = null;
        this.fileBaseUrl = null;
        this.serverUserName = null;
        this.strippedUserName = null;
        this.password = null;
        this.ntlmDomain = null;
        this.serverName = null;
        this.serverLocation = null;
        this.encodedServerLocation = null;
        this.serverPort = -1;
        this.proxyHost = null;
        this.proxyPortString = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
        this.proxyDomain = null;
        this.keystoreData = null;
        this.keystoreManager = null;
        this.proxy = null;
        this.httpClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
        this.hasSessionParameters = false;
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSessionParameters();
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(userName, this.serverName, this.serverPortString, this.serverLocation, this.serverProtocol, this.serverUserName, this.password, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        int index = userName.indexOf("@");
        if (index == -1) {
            throw new ManifoldCFException("Username is in unexpected form (no @): '" + userName + "'");
        }
        String userPart = userName.substring(0, index);
        String domainPart = userName.substring(index + 1);
        this.getSharePointSession();
        List<String> sharePointTokens = this.proxy.getAccessTokens("/", domainPart + "\\" + userPart);
        if (sharePointTokens == null) {
            return RESPONSE_USERNOTFOUND_ADDITIVE;
        }
        return new AuthorizationResponse(sharePointTokens.toArray(new String[0]), 0);
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE_ADDITIVE;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SharePointAuthority.Server"));
        tabsArray.add(Messages.getString(locale, "SharePointAuthority.Cache"));
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration.js", null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        SharePointAuthority.fillInCacheTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        SharePointAuthority.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Cache.html", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Server.html", velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String proxyPassword;
        String proxyUser;
        String proxyPort;
        String[] contents;
        String password;
        String userName;
        String serverLocation;
        String serverPort;
        String serverName;
        String serverProtocol;
        String serverClaimSpace;
        String serverVersion = parameters.getParameter("serverVersion");
        if (serverVersion == null) {
            serverVersion = "2.0";
        }
        if ((serverClaimSpace = parameters.getParameter("serverClaimSpace")) == null) {
            serverClaimSpace = "false";
        }
        if ((serverProtocol = parameters.getParameter("serverProtocol")) == null) {
            serverProtocol = "http";
        }
        if ((serverName = parameters.getParameter("serverName")) == null) {
            serverName = "localhost";
        }
        if ((serverPort = parameters.getParameter("serverPort")) == null) {
            serverPort = "";
        }
        if ((serverLocation = parameters.getParameter("serverLocation")) == null) {
            serverLocation = "";
        }
        if ((userName = parameters.getParameter("userName")) == null) {
            userName = "";
        }
        password = (password = parameters.getObfuscatedParameter("password")) == null ? "" : out.mapPasswordToKey(password);
        String keystore = parameters.getParameter("keystore");
        IKeystoreManager localKeystore = keystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)keystore);
        ArrayList certificates = new ArrayList();
        for (String alias : contents = localKeystore.getContents()) {
            String description = localKeystore.getDescription(alias);
            if (description.length() > 128) {
                description = description.substring(0, 125) + "...";
            }
            HashMap<String, String> certificate = new HashMap<String, String>();
            certificate.put("ALIAS", alias);
            certificate.put("DESCRIPTION", description);
            certificates.add(certificate);
        }
        String proxyHost = parameters.getParameter("proxyHost");
        if (proxyHost == null) {
            proxyHost = "";
        }
        if ((proxyPort = parameters.getParameter("proxyPort")) == null) {
            proxyPort = "";
        }
        if ((proxyUser = parameters.getParameter("proxyUser")) == null) {
            proxyUser = "";
        }
        proxyPassword = (proxyPassword = parameters.getParameter("proxyPassword")) == null ? "" : out.mapPasswordToKey(proxyPassword);
        String proxyDomain = parameters.getParameter("proxyDomain");
        if (proxyDomain == null) {
            proxyDomain = "";
        }
        velocityContext.put("SERVERVERSION", serverVersion);
        velocityContext.put("SERVERCLAIMSPACE", serverClaimSpace);
        velocityContext.put("SERVERPROTOCOL", serverProtocol);
        velocityContext.put("SERVERNAME", serverName);
        velocityContext.put("SERVERPORT", serverPort);
        velocityContext.put("SERVERLOCATION", serverLocation);
        velocityContext.put("SERVERUSERNAME", userName);
        velocityContext.put("SERVERPASSWORD", password);
        if (keystore != null) {
            velocityContext.put("KEYSTORE", keystore);
        }
        velocityContext.put("CERTIFICATELIST", certificates);
        velocityContext.put("PROXYHOST", proxyHost);
        velocityContext.put("PROXYPORT", proxyPort);
        velocityContext.put("PROXYUSER", proxyUser);
        velocityContext.put("PROXYPASSWORD", proxyPassword);
        velocityContext.put("PROXYDOMAIN", proxyDomain);
    }

    protected static void fillInCacheTab(Map<String, Object> velocityContext, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String cacheLifetime = parameters.getParameter("Cache lifetime");
        if (cacheLifetime == null) {
            cacheLifetime = "1";
        }
        velocityContext.put("CACHELIFETIME", cacheLifetime);
        String cacheLRUsize = parameters.getParameter("Cache LRU size");
        if (cacheLRUsize == null) {
            cacheLRUsize = "1000";
        }
        velocityContext.put("CACHELRUSIZE", cacheLRUsize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String configOp;
        String keystoreValue;
        String proxyDomain;
        String proxyPassword;
        String proxyUser;
        String proxyPort;
        String proxyHost;
        String password;
        String userName;
        String serverLocation;
        String serverPort;
        String serverName;
        String serverProtocol;
        String serverClaimSpace;
        String serverVersion;
        String cacheLRUsize;
        String cacheLifetime = variableContext.getParameter("cachelifetime");
        if (cacheLifetime != null) {
            parameters.setParameter("Cache lifetime", cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter("cachelrusize")) != null) {
            parameters.setParameter("Cache LRU size", cacheLRUsize);
        }
        if ((serverVersion = variableContext.getParameter("serverVersion")) != null) {
            parameters.setParameter("serverVersion", serverVersion);
        }
        if ((serverClaimSpace = variableContext.getParameter("serverClaimSpace")) != null) {
            parameters.setParameter("serverClaimSpace", serverClaimSpace);
        }
        if ((serverProtocol = variableContext.getParameter("serverProtocol")) != null) {
            parameters.setParameter("serverProtocol", serverProtocol);
        }
        if ((serverName = variableContext.getParameter("serverName")) != null) {
            parameters.setParameter("serverName", serverName);
        }
        if ((serverPort = variableContext.getParameter("serverPort")) != null) {
            parameters.setParameter("serverPort", serverPort);
        }
        if ((serverLocation = variableContext.getParameter("serverLocation")) != null) {
            parameters.setParameter("serverLocation", serverLocation);
        }
        if ((userName = variableContext.getParameter("serverUserName")) != null) {
            parameters.setParameter("userName", userName);
        }
        if ((password = variableContext.getParameter("serverPassword")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((proxyHost = variableContext.getParameter("proxyhost")) != null) {
            parameters.setParameter("proxyHost", proxyHost);
        }
        if ((proxyPort = variableContext.getParameter("proxyport")) != null) {
            parameters.setParameter("proxyPort", proxyPort);
        }
        if ((proxyUser = variableContext.getParameter("proxyuser")) != null) {
            parameters.setParameter("proxyUser", proxyUser);
        }
        if ((proxyPassword = variableContext.getParameter("proxypassword")) != null) {
            parameters.setObfuscatedParameter("proxyPassword", variableContext.mapKeyToPassword(proxyPassword));
        }
        if ((proxyDomain = variableContext.getParameter("proxydomain")) != null) {
            parameters.setParameter("proxyDomain", proxyDomain);
        }
        if ((keystoreValue = variableContext.getParameter("keystoredata")) != null) {
            parameters.setParameter("keystore", keystoreValue);
        }
        if ((configOp = variableContext.getParameter("configop")) != null) {
            if (configOp.equals("Delete")) {
                String alias = variableContext.getParameter("shpkeystorealias");
                keystoreValue = parameters.getParameter("keystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                parameters.setParameter("keystore", mgr.getString());
            } else if (configOp.equals("Add")) {
                String alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("shpcertificate");
                keystoreValue = parameters.getParameter("keystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                parameters.setParameter("keystore", mgr.getString());
            }
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        SharePointAuthority.fillInCacheTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        SharePointAuthority.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration.html", velocityContext);
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            try {
                this.responseLifetime = Long.parseLong(this.cacheLifetime) * 60L * 1000L;
                this.LRUsize = Integer.parseInt(this.cacheLRUsize);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage(), (Throwable)e);
            }
            this.hasSessionParameters = true;
        }
    }

    protected void getSharePointSession() throws ManifoldCFException {
        if (this.proxy == null) {
            try {
                this.serverPort = this.serverPortString == null || this.serverPortString.length() == 0 ? (this.serverProtocol.equals("https") ? 443 : 80) : Integer.parseInt(this.serverPortString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            int proxyPort = 8080;
            if (this.proxyPortString != null && this.proxyPortString.length() > 0) {
                try {
                    proxyPort = Integer.parseInt(this.proxyPortString);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            this.serverUrl = this.serverProtocol + "://" + this.serverName;
            if (this.serverProtocol.equals("https")) {
                if (this.serverPort != 443) {
                    this.serverUrl = this.serverUrl + ":" + Integer.toString(this.serverPort);
                }
            } else if (this.serverPort != 80) {
                this.serverUrl = this.serverUrl + ":" + Integer.toString(this.serverPort);
            }
            this.fileBaseUrl = this.serverUrl + this.encodedServerLocation;
            int connectionTimeout = 60000;
            int socketTimeout = 900000;
            SSLConnectionSocketFactory myFactory = null;
            if (this.keystoreData != null) {
                this.keystoreManager = KeystoreManagerFactory.make((String)"", (String)this.keystoreData);
                myFactory = new SSLConnectionSocketFactory(this.keystoreManager.getSecureSocketFactory(), (HostnameVerifier)new DefaultHostnameVerifier());
            } else {
                myFactory = SSLConnectionSocketFactory.getSocketFactory();
            }
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(60000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.strippedUserName != null) {
                credentialsProvider.setCredentials(new AuthScope(this.serverName, this.serverPort), (Credentials)new NTCredentials(this.strippedUserName, this.password, currentHost, this.ntlmDomain));
            }
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(false).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
            if (this.proxyHost != null && this.proxyHost.length() > 0) {
                if (this.proxyUsername != null && this.proxyUsername.length() > 0) {
                    if (this.proxyPassword == null) {
                        this.proxyPassword = "";
                    }
                    if (this.proxyDomain == null) {
                        this.proxyDomain = "";
                    }
                    credentialsProvider.setCredentials(new AuthScope(this.proxyHost, proxyPort), (Credentials)new NTCredentials(this.proxyUsername, this.proxyPassword, currentHost, this.proxyDomain));
                }
                HttpHost proxy = new HttpHost(this.proxyHost, proxyPort);
                requestBuilder.setProxy(proxy);
            }
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            builder.setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
            this.httpClient = builder.build();
            this.proxy = new SPSProxyHelper(this.serverUrl, this.encodedServerLocation, this.serverLocation, this.serverUserName, this.password, CommonsHTTPSender.class, "client-config.wsdd", this.httpClient, this.isClaimSpace);
        }
        this.sharepointSessionTimeout = System.currentTimeMillis() + 300000L;
    }

    protected void expireSharePointSession() throws ManifoldCFException {
        this.serverPort = -1;
        this.serverUrl = null;
        this.fileBaseUrl = null;
        this.keystoreManager = null;
        this.proxy = null;
        this.httpClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
    }

    public static String pathItemDecode(String pathItem) {
        return URLDecoder.decode((String)pathItem.replaceAll("\\%20", "+"));
    }

    public static String pathItemEncode(String pathItem) {
        String output = URLEncoder.encode((String)pathItem);
        return output.replaceAll("\\+", "%20");
    }

    public static String decodePath(String relPath) {
        StringBuilder sb = new StringBuilder();
        String[] pathEntries = relPath.split("/");
        int k = 0;
        boolean isFirst = true;
        while (k < pathEntries.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("/");
            }
            sb.append(SharePointAuthority.pathItemDecode(pathEntries[k++]));
        }
        return sb.toString();
    }

    public static String encodePath(String relPath) {
        StringBuilder sb = new StringBuilder();
        String[] pathEntries = relPath.split("/");
        int k = 0;
        boolean isFirst = true;
        while (k < pathEntries.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("/");
            }
            sb.append(SharePointAuthority.pathItemEncode(pathEntries[k++]));
        }
        return sb.toString();
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        emptyStringSet = new StringSet();
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected final String userName;
        protected final long responseLifetime;
        protected long expirationTime = -1L;
        protected final String serverName;
        protected final String serverPortString;
        protected final String serverLocation;
        protected final String serverProtocol;
        protected final String serverUserName;
        protected final String password;

        public AuthorizationResponseDescription(String userName, String serverName, String serverPortString, String serverLocation, String serverProtocol, String serverUserName, String password, long responseLifetime, int LRUsize) {
            super("SharePointAuthority", LRUsize);
            this.userName = userName;
            this.responseLifetime = responseLifetime;
            this.serverName = serverName;
            this.serverPortString = serverPortString;
            this.serverLocation = serverLocation;
            this.serverProtocol = serverProtocol;
            this.serverUserName = serverUserName;
            this.password = password;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName);
            sb.append("-").append(this.serverName);
            sb.append("-").append(this.serverPortString);
            sb.append("-").append(this.serverLocation);
            sb.append("-").append(this.serverProtocol);
            sb.append("-").append(this.serverUserName);
            sb.append("-").append(this.password);
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            int rval = this.userName.hashCode();
            rval += this.serverName.hashCode();
            rval += this.serverPortString.hashCode();
            rval += this.serverLocation.hashCode();
            rval += this.serverProtocol.hashCode();
            rval += this.serverUserName.hashCode();
            return rval += this.password.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            if (!ard.serverName.equals(this.serverName)) {
                return false;
            }
            if (!ard.serverPortString.equals(this.serverPortString)) {
                return false;
            }
            if (!ard.serverLocation.equals(this.serverLocation)) {
                return false;
            }
            if (!ard.serverProtocol.equals(this.serverProtocol)) {
                return false;
            }
            if (!ard.serverUserName.equals(this.serverUserName)) {
                return false;
            }
            return ard.password.equals(this.password);
        }
    }
}

