/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformationconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.agents.transformationconnection.TransformationConnection;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;

public class TransformationConnectionManager
extends BaseTable
implements ITransformationConnectionManager {
    public static final String _rcsid = "@(#)$Id: TransformationConnectionManager.java 1642320 2014-11-28 17:03:12Z kwright $";
    private static final String passwordSuffix = "password";
    protected static final String nameField = "connectionname";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected static final String maxCountField = "maxcount";
    protected static final String configField = "configxml";
    protected final ICacheManager cacheManager;
    protected final IThreadContext threadContext;
    protected final ILockManager lockManager;
    protected static final String transformationsLock = "TRANSFORMATIONS_LOCK";
    protected static final int FETCH_MAX = 200;

    public TransformationConnectionManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "transformationconnections");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(classNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(maxCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(configField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription classIndex = new IndexDescription(false, new String[]{classNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (classIndex != null && id.equals((Object)classIndex)) {
                    classIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (classIndex == null) break block3;
            this.performAddIndex(null, classIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    @Override
    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)1);
        ITransformationConnection[] list = this.getAllConnections();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            ITransformationConnection conn = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getClassName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getConfigParams().toXML());
            ManifoldCF.writeDword((OutputStream)os, (int)conn.getMaxConnections());
        }
    }

    @Override
    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 1) {
            throw new IOException("Unknown transformation connection configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            ITransformationConnection conn = this.create();
            conn.setName(ManifoldCF.readString((InputStream)is));
            conn.setDescription(ManifoldCF.readString((InputStream)is));
            conn.setClassName(ManifoldCF.readString((InputStream)is));
            conn.getConfigParams().fromXML(ManifoldCF.readString((InputStream)is));
            conn.setMaxConnections(ManifoldCF.readDword((InputStream)is));
            this.save(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransformationConnection[] getAllConnections() throws ManifoldCFException {
        this.lockManager.enterReadLock(transformationsLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(TransformationConnectionManager.getTransformationConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT connectionname,lower(connectionname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            ITransformationConnection[] iTransformationConnectionArray = this.loadMultiple(names);
            return iTransformationConnectionArray;
        }
        finally {
            this.lockManager.leaveReadLock(transformationsLock);
        }
    }

    @Override
    public ITransformationConnection load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    @Override
    public ITransformationConnection[] loadMultiple(String[] names) throws ManifoldCFException {
        ITransformationConnection[] rval = new ITransformationConnection[names.length];
        if (names.length == 0) {
            return rval;
        }
        int inputIndex = 0;
        int outputIndex = 0;
        while (names.length - inputIndex > 200) {
            outputIndex = this.loadMultipleInternal(rval, outputIndex, names, inputIndex, 200);
            inputIndex += 200;
        }
        this.loadMultipleInternal(rval, outputIndex, names, inputIndex, names.length - inputIndex);
        return rval;
    }

    protected int loadMultipleInternal(ITransformationConnection[] rval, int outputIndex, String[] fetchNames, int inputIndex, int length) throws ManifoldCFException {
        TransformationConnection[] results;
        TransformationConnectionDescription[] objectDescriptions = new TransformationConnectionDescription[length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < length; ++i) {
            ssb.clear();
            String name = fetchNames[inputIndex + i];
            ssb.add(TransformationConnectionManager.getTransformationConnectionKey(name));
            objectDescriptions[i] = new TransformationConnectionDescription(name, new StringSet(ssb));
        }
        TransformationConnectionExecutor exec = new TransformationConnectionExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        for (TransformationConnection result : results = exec.getResults()) {
            rval[outputIndex++] = result;
        }
        return outputIndex;
    }

    @Override
    public ITransformationConnection create() throws ManifoldCFException {
        TransformationConnection rval = new TransformationConnection();
        return rval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(ITransformationConnection object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(TransformationConnectionManager.getTransformationConnectionsKey());
        ssb.add(TransformationConnectionManager.getTransformationConnectionKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        this.lockManager.enterNonExWriteLock(transformationsLock);
        try {
            ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
            try {
                this.beginTransaction();
                try {
                    if (AgentManagerFactory.isTransformationConnectionInUse(this.threadContext, name)) {
                        throw new ManifoldCFException("Can't delete transformation connection '" + name + "': existing entities refer to it");
                    }
                    ManifoldCF.noteConfigurationChange();
                    ArrayList params = new ArrayList();
                    String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
                    this.performDelete("WHERE " + query, params, null);
                    this.cacheManager.invalidateKeys(ch);
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            finally {
                this.cacheManager.leaveCache(ch);
            }
        }
        finally {
            this.lockManager.leaveNonExWriteLock(transformationsLock);
        }
    }

    @Override
    public String[] findConnectionsForConnector(String className) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(TransformationConnectionManager.getTransformationConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(classNameField, (Object)className)});
        IResultSet set = this.performQuery("SELECT connectionname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
        Object[] rval = new String[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(nameField);
        }
        Arrays.sort(rval);
        return rval;
    }

    @Override
    public boolean checkConnectorExists(String name) throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(TransformationConnectionManager.getTransformationConnectionKey(name));
            StringSet localCacheKeys = new StringSet(ssb);
            ArrayList params = new ArrayList();
            String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
            IResultSet set = this.performQuery("SELECT classname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("No such connection: '" + name + "'");
            }
            IResultRow row = set.getRow(0);
            String className = (String)row.getValue(classNameField);
            ITransformationConnectorManager cm = TransformationConnectorManagerFactory.make(this.threadContext);
            boolean bl = cm.isInstalled(className);
            return bl;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public String getConnectionNameColumn() {
        return nameField;
    }

    protected static String getTransformationConnectionsKey() {
        return CacheKeyFactory.makeTransformationConnectionsKey();
    }

    protected static String getTransformationConnectionKey(String connectionName) {
        return CacheKeyFactory.makeTransformationConnectionKey(connectionName);
    }

    protected TransformationConnection[] getTransformationConnectionsMultiple(String[] connectionNames) throws ManifoldCFException {
        int i;
        TransformationConnection[] rval = new TransformationConnection[connectionNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < connectionNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(connectionNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.maxClauseGetTransformationConnectionsChunk();
            while (i < connectionNames.length) {
                if (j == maxIn) {
                    this.getTransformationConnectionsChunk(rval, returnIndex, params);
                    params.clear();
                    j = 0;
                }
                params.add(connectionNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getTransformationConnectionsChunk(rval, returnIndex, params);
            }
            TransformationConnection[] transformationConnectionArray = rval;
            return transformationConnectionArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected int maxClauseGetTransformationConnectionsChunk() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void getTransformationConnectionsChunk(TransformationConnection[] rval, Map<String, Integer> returnIndex, ArrayList params) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(nameField, (List)params)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = returnIndex.get(name);
            TransformationConnection rc = new TransformationConnection();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rc.setClassName((String)row.getValue(classNameField));
            rc.setMaxConnections((int)((Long)row.getValue(maxCountField)).longValue());
            String xml = (String)row.getValue(configField);
            if (xml != null && xml.length() > 0) {
                rc.getConfigParams().fromXML(xml);
            }
            rval[index] = rc;
        }
    }

    protected static class TransformationConnectionExecutor
    extends ExecutorBase {
        protected TransformationConnectionManager thisManager;
        protected TransformationConnection[] returnValues;
        protected HashMap returnMap = new HashMap();

        public TransformationConnectionExecutor(TransformationConnectionManager manager, TransformationConnectionDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new TransformationConnection[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getConnectionName(), new Integer(i));
            }
        }

        public TransformationConnection[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] connectionNames = new String[objectDescriptions.length];
            for (int i = 0; i < connectionNames.length; ++i) {
                TransformationConnectionDescription desc = (TransformationConnectionDescription)objectDescriptions[i];
                connectionNames[i] = desc.getConnectionName();
            }
            return this.thisManager.getTransformationConnectionsMultiple(connectionNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            TransformationConnectionDescription objectDesc = (TransformationConnectionDescription)objectDescription;
            TransformationConnection ci = (TransformationConnection)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getConnectionName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class TransformationConnectionDescription
    extends BaseDescription {
        protected String connectionName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public TransformationConnectionDescription(String connectionName, StringSet invKeys) {
            super("transformationconnectioncache");
            this.connectionName = connectionName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + connectionName;
            this.cacheKeys = invKeys;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TransformationConnectionDescription)) {
                return false;
            }
            TransformationConnectionDescription d = (TransformationConnectionDescription)((Object)o);
            return d.connectionName.equals(this.connectionName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

