/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.generic;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.generic.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.generic.api.Auth;
import org.apache.manifoldcf.ui.util.Encoder;

public class GenericAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: GenericAuthority.java 1496653 2013-06-25 22:05:04Z mlizewski $";
    private static final String globalDenyToken = "DEAD_AUTHORITY";
    private static final AuthorizationResponse unreachableResponse = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 1);
    private static final AuthorizationResponse userNotFoundResponse = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 2);
    private static final String ACTION_PARAM_NAME = "action";
    private static final String ACTION_AUTH = "auth";
    private static final String ACTION_CHECK = "check";
    private String genericLogin = null;
    private String genericPassword = null;
    private String genericEntryPoint = null;
    private int connectionTimeoutMillis = 60000;
    private int socketTimeoutMillis = 1800000;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private DefaultHttpClient client = null;
    private long sessionExpirationTime = -1L;
    private ICacheManager cacheManager = null;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.genericEntryPoint = this.getParam(configParams, "genericEntryPoint", null);
        this.genericLogin = this.getParam(configParams, "genericLogin", null);
        this.genericPassword = "";
        try {
            this.genericPassword = ManifoldCF.deobfuscate((String)this.getParam(configParams, "genericPassword", ""));
        }
        catch (ManifoldCFException manifoldCFException) {
            // empty catch block
        }
        this.connectionTimeoutMillis = Integer.parseInt(this.getParam(configParams, "genericConnectionTimeout", "60000"));
        if (this.connectionTimeoutMillis == 0) {
            this.connectionTimeoutMillis = 60000;
        }
        this.socketTimeoutMillis = Integer.parseInt(this.getParam(configParams, "genericSocketTimeout", "1800000"));
        if (this.socketTimeoutMillis == 0) {
            this.socketTimeoutMillis = 1800000;
        }
        this.responseLifetime = Long.parseLong(this.getParam(configParams, "genericResponseLifetime", "60000"));
        if (this.responseLifetime == 0L) {
            this.responseLifetime = 60000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultHttpClient getClient() throws ManifoldCFException {
        GenericAuthority genericAuthority = this;
        synchronized (genericAuthority) {
            if (this.client != null) {
                return this.client;
            }
            DefaultHttpClient cl = new DefaultHttpClient();
            if (this.genericLogin != null && !this.genericLogin.isEmpty()) {
                try {
                    URL url = new URL(this.genericEntryPoint);
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.genericLogin, this.genericPassword);
                    cl.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), url.getPort() > 0 ? url.getPort() : 80, AuthScope.ANY_REALM), (Credentials)credentials);
                    cl.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth((Credentials)credentials), 0);
                }
                catch (MalformedURLException ex) {
                    this.client = null;
                    this.sessionExpirationTime = -1L;
                    throw new ManifoldCFException("getClient exception: " + ex.getMessage(), (Throwable)ex);
                }
            }
            HttpConnectionParams.setConnectionTimeout((HttpParams)cl.getParams(), (int)this.connectionTimeoutMillis);
            HttpConnectionParams.setSoTimeout((HttpParams)cl.getParams(), (int)this.socketTimeoutMillis);
            this.sessionExpirationTime = System.currentTimeMillis() + 300000L;
            this.client = cl;
            return cl;
        }
    }

    public void poll() throws ManifoldCFException {
        if (this.client != null && System.currentTimeMillis() > this.sessionExpirationTime) {
            this.disconnectSession();
        }
        super.poll();
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public String check() throws ManifoldCFException {
        DefaultHttpClient client = this.getClient();
        try {
            CheckThread checkThread = new CheckThread((HttpClient)client, this.genericEntryPoint + "?" + ACTION_PARAM_NAME + "=" + ACTION_CHECK);
            checkThread.start();
            checkThread.join();
            if (checkThread.getException() != null) {
                Throwable thr = checkThread.getException();
                return "Check exception: " + thr.getMessage();
            }
            return checkThread.getResult();
        }
        catch (InterruptedException ex) {
            throw new ManifoldCFException(ex.getMessage(), (Throwable)ex, 2);
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.disconnectSession();
        super.disconnect();
        this.genericEntryPoint = null;
        this.genericLogin = null;
        this.genericPassword = null;
    }

    protected String createCacheConnectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genericEntryPoint).append("#").append(this.genericLogin);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        DefaultHttpClient client = this.getClient();
        GenericAuthorizationResponseDescription objectDescription = new GenericAuthorizationResponseDescription(userName, this.createCacheConnectionString(), this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached((HttpClient)client, userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(HttpClient client, String userName) throws ManifoldCFException {
        StringBuilder url = new StringBuilder(this.genericEntryPoint);
        url.append("?").append(ACTION_PARAM_NAME).append("=").append(ACTION_AUTH);
        url.append("&username=").append(URLEncoder.encode((String)userName));
        try {
            FetchTokensThread t = new FetchTokensThread(client, url.toString());
            t.start();
            t.join();
            if (t.getException() != null) {
                return unreachableResponse;
            }
            Auth auth = t.getAuthResponse();
            if (auth == null) {
                return userNotFoundResponse;
            }
            if (!auth.exists.booleanValue()) {
                return userNotFoundResponse;
            }
            if (auth.tokens == null) {
                return new AuthorizationResponse(new String[0], 0);
            }
            String[] tokens = new String[auth.tokens.size()];
            for (int k = 0; k < tokens.length; ++k) {
                tokens[k] = auth.tokens.get(k);
            }
            return new AuthorizationResponse(tokens, 0);
        }
        catch (InterruptedException ex) {
            throw new ManifoldCFException(ex.getMessage(), (Throwable)ex, 2);
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return unreachableResponse;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "generic.EntryPoint"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig() {\n  return true;\n}\n\nfunction checkConfigForSave() {\n  if (editconnection.genericEntryPoint.value == \"\") {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "generic.EntryPointCannotBeBlank") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "generic.EntryPoint") + "\");\n" + "    editconnection.genericEntryPoint.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "//-->\n" + "</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String server = this.getParam(parameters, "genericEntryPoint", "");
        String login = this.getParam(parameters, "genericLogin", "");
        String password = "";
        try {
            password = ManifoldCF.deobfuscate((String)this.getParam(parameters, "genericPassword", ""));
        }
        catch (ManifoldCFException ignore) {
            // empty catch block
        }
        String conTimeout = this.getParam(parameters, "genericConnectionTimeout", "60000");
        String soTimeout = this.getParam(parameters, "genericSocketTimeout", "1800000");
        String respLifetime = this.getParam(parameters, "genericResponseLifetime", "60000");
        if (tabName.equals(Messages.getString(locale, "generic.EntryPoint"))) {
            out.print("<table class=\"displaytable\">\n <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n <tr>\n  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.EntryPointColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericEntryPoint\" value=\"" + Encoder.attributeEscape((String)server) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.LoginColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericLogin\" value=\"" + Encoder.attributeEscape((String)login) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.PasswordColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"password\" size=\"32\" name=\"genericPassword\" value=\"" + Encoder.attributeEscape((String)password) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.ConnectionTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericConTimeout\" value=\"" + Encoder.attributeEscape((String)conTimeout) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.SocketTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericSoTimeout\" value=\"" + Encoder.attributeEscape((String)soTimeout) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.ResponseLifetimeColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"genericResponseLifetime\" value=\"" + Encoder.attributeEscape((String)respLifetime) + "\"/></td>\n" + " </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"genericEntryPoint\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericLogin\" value=\"" + Encoder.attributeEscape((String)login) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericPassword\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericConTimeout\" value=\"" + Encoder.attributeEscape((String)conTimeout) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericSoTimeout\" value=\"" + Encoder.attributeEscape((String)soTimeout) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"genericResponseLifetime\" value=\"" + Encoder.attributeEscape((String)respLifetime) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        this.copyParam(variableContext, parameters, "genericLogin");
        this.copyParam(variableContext, parameters, "genericEntryPoint");
        this.copyParam(variableContext, parameters, "genericConTimeout");
        this.copyParam(variableContext, parameters, "genericSoTimeout");
        this.copyParam(variableContext, parameters, "genericResponseLifetime");
        String password = variableContext.getParameter("genericPassword");
        if (password == null) {
            password = "";
        }
        parameters.setParameter("genericPassword", org.apache.manifoldcf.core.system.ManifoldCF.obfuscate((String)password));
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        String login = this.getParam(parameters, "genericLogin", "");
        String server = this.getParam(parameters, "genericEntryPoint", "");
        String conTimeout = this.getParam(parameters, "genericConnectionTimeout", "60000");
        String soTimeout = this.getParam(parameters, "genericSocketTimeout", "1800000");
        String respLifetime = this.getParam(parameters, "genericResponseLifetime", "60000");
        out.print("<table class=\"displaytable\">\n <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n <tr>\n  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.EntryPointColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)server) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.LoginColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)login) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.PasswordColon") + "</nobr></td>\n" + "  <td class=\"value\">**********</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.ConnectionTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)conTimeout) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.SocketTimeoutColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)soTimeout) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "generic.ResponseLifetimeColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)respLifetime) + "</td>\n" + " </tr>\n" + "</table>\n");
    }

    private String getParam(ConfigParams parameters, String name, String def) {
        return parameters.getParameter(name) != null ? parameters.getParameter(name) : def;
    }

    private boolean copyParam(IPostParameters variableContext, ConfigParams parameters, String name) {
        String val = variableContext.getParameter(name);
        if (val == null) {
            return false;
        }
        parameters.setParameter(name, val);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSession() {
        GenericAuthority genericAuthority = this;
        synchronized (genericAuthority) {
            this.client.getConnectionManager().shutdown();
            this.client = null;
        }
    }

    protected static class FetchTokensThread
    extends Thread {
        protected HttpClient client;
        protected String url;
        protected Throwable exception = null;
        protected Auth auth;

        public FetchTokensThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
            this.auth = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpGet method = new HttpGet(this.url.toString());
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.exception = new ManifoldCFException("FetchTokensThread error - interface returned incorrect return code for: " + this.url + " - " + response.getStatusLine().toString());
                        return;
                    }
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Auth.class});
                    Unmarshaller m = context.createUnmarshaller();
                    this.auth = (Auth)m.unmarshal(response.getEntity().getContent());
                }
                catch (JAXBException ex) {
                    this.exception = ex;
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public Auth getAuthResponse() {
            return this.auth;
        }
    }

    protected static class CheckThread
    extends Thread {
        protected HttpClient client;
        protected String url;
        protected Throwable exception = null;
        protected String result = "Unknown";

        public CheckThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpGet method = new HttpGet(this.url);
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.result = "Connection failed: " + response.getStatusLine().getReasonPhrase();
                        return;
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    this.result = "Connection OK";
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getResult() {
            return this.result;
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private Credentials credentials;

        public PreemptiveAuth(Credentials creds) {
            this.credentials = creds;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.addHeader(new BasicScheme(StandardCharsets.US_ASCII).authenticate(this.credentials, request, context));
        }
    }

    protected class GenericAuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected String connectionString;
        protected long responseLifetime;
        protected long expirationTime;

        public GenericAuthorizationResponseDescription(String userName, String connectionString, long responseLifetime, int LRUsize) {
            super("LDAPAuthority", LRUsize);
            this.expirationTime = -1L;
            this.userName = userName;
            this.connectionString = connectionString;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName).append("-").append(this.connectionString);
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.connectionString.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof GenericAuthorizationResponseDescription)) {
                return false;
            }
            GenericAuthorizationResponseDescription ard = (GenericAuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            return ard.connectionString.equals(this.connectionString);
        }
    }
}

