/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.util;

import java.util.List;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractIterator;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionIterator<T>
extends AbstractIterator<T> {
    public CollectionIterator(long skipCount, AbstractPageFetcher<T> pageFetcher) {
        super(skipCount, pageFetcher);
    }

    @Override
    public boolean hasNext() {
        AbstractPageFetcher.Page page = this.getCurrentPage();
        if (page == null) {
            return false;
        }
        List items = page.getItems();
        if (items != null && this.getSkipOffset() < items.size()) {
            return true;
        }
        if (!this.getHasMoreItems()) {
            return false;
        }
        long totalItems = this.getTotalNumItems();
        if (totalItems < 0L) {
            return true;
        }
        return this.getSkipCount() + (long)this.getSkipOffset() < totalItems;
    }

    @Override
    public T next() {
        AbstractPageFetcher.Page page = this.getCurrentPage();
        if (page == null) {
            return null;
        }
        List items = page.getItems();
        if (items == null || items.isEmpty()) {
            return null;
        }
        if (this.getSkipOffset() == items.size()) {
            page = this.incrementPage();
            List list = items = page == null ? null : page.getItems();
        }
        if (items == null || items.isEmpty() || this.getSkipOffset() == items.size()) {
            return null;
        }
        return items.get(this.incrementSkipOffset());
    }
}

