/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.hppc.LongArrayList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class MultiGetShardRequest
extends SingleShardOperationRequest<MultiGetShardRequest> {
    private int shardId;
    private String preference;
    Boolean realtime;
    boolean refresh;
    IntArrayList locations;
    List<String> types;
    List<String> ids;
    List<String[]> fields;
    LongArrayList versions;
    List<VersionType> versionTypes;
    List<FetchSourceContext> fetchSourceContexts;

    MultiGetShardRequest() {
    }

    MultiGetShardRequest(String index, int shardId) {
        super(index);
        this.shardId = shardId;
        this.locations = new IntArrayList();
        this.types = new ArrayList<String>();
        this.ids = new ArrayList<String>();
        this.fields = new ArrayList<String[]>();
        this.versions = new LongArrayList();
        this.versionTypes = new ArrayList<VersionType>();
        this.fetchSourceContexts = new ArrayList<FetchSourceContext>();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiGetShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public MultiGetShardRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetShardRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public void add(int location, @Nullable String type, String id, String[] fields, long version, VersionType versionType, FetchSourceContext fetchSourceContext) {
        this.locations.add(location);
        this.types.add(type);
        this.ids.add(id);
        this.fields.add(fields);
        this.versions.add(version);
        this.versionTypes.add(versionType);
        this.fetchSourceContexts.add(fetchSourceContext);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.types = new ArrayList<String>(size);
        this.ids = new ArrayList<String>(size);
        this.fields = new ArrayList<String[]>(size);
        this.versions = new LongArrayList(size);
        this.versionTypes = new ArrayList<VersionType>(size);
        this.fetchSourceContexts = new ArrayList<FetchSourceContext>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.types.add(in.readSharedString());
            } else {
                this.types.add(null);
            }
            this.ids.add(in.readString());
            int size1 = in.readVInt();
            if (size1 > 0) {
                String[] fields = new String[size1];
                for (int j = 0; j < size1; ++j) {
                    fields[j] = in.readString();
                }
                this.fields.add(fields);
            } else {
                this.fields.add(null);
            }
            this.versions.add(in.readVLong());
            this.versionTypes.add(VersionType.fromValue(in.readByte()));
            this.fetchSourceContexts.add(FetchSourceContext.optionalReadFromStream(in));
        }
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        byte realtime = in.readByte();
        if (realtime == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.types.size());
        for (int i = 0; i < this.types.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.types.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeSharedString(this.types.get(i));
            }
            out.writeString(this.ids.get(i));
            if (this.fields.get(i) == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.get(i).length);
                for (String field : this.fields.get(i)) {
                    out.writeString(field);
                }
            }
            out.writeVLong(this.versions.get(i));
            out.writeByte(this.versionTypes.get(i).getValue());
            FetchSourceContext fetchSourceContext = this.fetchSourceContexts.get(i);
            FetchSourceContext.optionalWriteToStream(fetchSourceContext, out);
        }
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
    }
}

