/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequest;
import org.elasticsearch.action.admin.indices.status.IndicesStatusResponse;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestTable;

public class RestRecoveryAction
extends AbstractCatAction {
    @Inject
    protected RestRecoveryAction(Settings settings, Client client, RestController restController) {
        super(settings, client);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/recovery", this);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/recovery/{index}", this);
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/recovery\n");
        sb.append("/_cat/recovery/{index}\n");
    }

    @Override
    public void doRequest(final RestRequest request, final RestChannel channel) {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

            @Override
            public void onResponse(final ClusterStateResponse clusterStateResponse) {
                IndicesStatusRequest indicesStatusRequest = new IndicesStatusRequest(indices);
                indicesStatusRequest.recovery(true);
                indicesStatusRequest.operationThreading(BroadcastOperationThreading.SINGLE_THREAD);
                RestRecoveryAction.this.client.admin().indices().status(indicesStatusRequest, new ActionListener<IndicesStatusResponse>(){

                    @Override
                    public void onResponse(IndicesStatusResponse indicesStatusResponse) {
                        HashMap<String, Long> primarySizes = new HashMap<String, Long>();
                        HashSet<ShardStatus> replicas = new HashSet<ShardStatus>();
                        for (ShardStatus shardStatus : indicesStatusResponse.getShards()) {
                            if (shardStatus.getShardRouting().primary()) {
                                primarySizes.put(shardStatus.getShardRouting().getIndex() + shardStatus.getShardRouting().getId(), shardStatus.getStoreSize().bytes());
                                continue;
                            }
                            if (shardStatus.getState() != IndexShardState.RECOVERING) continue;
                            replicas.add(shardStatus);
                        }
                        try {
                            channel.sendResponse(RestTable.buildResponse(RestRecoveryAction.this.buildRecoveryTable(request, clusterStateResponse, primarySizes, replicas), request, channel));
                        }
                        catch (Throwable e) {
                            try {
                                channel.sendResponse(new XContentThrowableRestResponse(request, e));
                            }
                            catch (IOException e2) {
                                RestRecoveryAction.this.logger.error("Unable to send recovery status response", e2, new Object[0]);
                            }
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        try {
                            channel.sendResponse(new XContentThrowableRestResponse(request, e));
                        }
                        catch (IOException e1) {
                            RestRecoveryAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                        }
                    }
                });
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestRecoveryAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table t = new Table();
        t.startHeaders().addCell("index", "alias:i,idx;desc:index name").addCell("shard", "alias:s,sh;desc:shard name").addCell("target", "alias:t;text-align:right;desc:bytes of source shard").addCell("recovered", "alias:r;text-align:right;desc:bytes recovered so far").addCell("percent", "alias:per,ratio;text-align:right;desc:percent recovered so far").addCell("host", "alias:h;desc:node host where source shard lives").addCell("ip", "desc:node ip where source shard lives").addCell("node", "alias:n;desc:node name where source shard lives").endHeaders();
        return t;
    }

    public Table buildRecoveryTable(RestRequest request, ClusterStateResponse state, Map<String, Long> primarySizes, Set<ShardStatus> recoveringReplicas) {
        Table t = this.getTableWithHeader(request);
        for (ShardStatus status : recoveringReplicas) {
            DiscoveryNode node = state.getState().nodes().get(status.getShardRouting().currentNodeId());
            String index = status.getShardRouting().getIndex();
            int id = status.getShardId();
            long replicaSize = status.getStoreSize().bytes();
            Long primarySize = primarySizes.get(index + id);
            t.startRow();
            t.addCell(index);
            t.addCell(id);
            t.addCell(primarySize);
            t.addCell(replicaSize);
            t.addCell(primarySize == null ? null : String.format(Locale.ROOT, "%1.1f%%", 100.0 * (double)replicaSize / (double)primarySize.longValue()));
            t.addCell(node == null ? null : node.getHostName());
            t.addCell(node == null ? null : node.getHostAddress());
            t.addCell(node == null ? null : node.name());
            t.endRow();
        }
        return t;
    }
}

