/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.encoder;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import jj2000.j2k.encoder.Encoder;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;

public class CmdLnEncoder {
    private ParameterList pl;
    private ParameterList defpl = new ParameterList();
    private Encoder enc;

    public static void main(String[] argv) {
        if (argv.length == 0) {
            FacilityManager.getMsgLogger().println("CmdLnEncoder: JJ2000's JPEG 2000 Encoder\n    use jj2000.j2k.encoder.CmdLnEncoder -u to get help\n", 0, 0);
            System.exit(1);
        }
        new CmdLnEncoder(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmdLnEncoder(String[] argv) {
        String[][] param = Encoder.getAllParameters();
        for (int i = param.length - 1; i >= 0; --i) {
            if (param[i][3] == null) continue;
            this.defpl.put(param[i][0], param[i][3]);
        }
        this.pl = new ParameterList(this.defpl);
        if (argv.length == 0) {
            throw new IllegalArgumentException("No arguments!");
        }
        try {
            this.pl.parseArgs(argv);
        }
        catch (StringFormatException e) {
            System.err.println("An error occurred while parsing the arguments:\n" + e.getMessage());
            return;
        }
        if (this.pl.getParameter("pfile") != null) {
            InputStream is;
            ParameterList tmpPl = new ParameterList();
            try {
                is = new FileInputStream(this.pl.getParameter("pfile"));
                is = new BufferedInputStream(is);
                tmpPl.load(is);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not load the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            catch (IOException e) {
                System.err.println("An error occurred while reading from the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                System.out.println("[WARNING] Could not close the argument file after reading");
            }
            Enumeration<Object> en = tmpPl.keys();
            while (en.hasMoreElements()) {
                String str = (String)en.nextElement();
                if (this.pl.get(str) != null) continue;
                this.pl.put(str, tmpPl.get(str));
            }
        }
        try {
            this.pl.checkList(Encoder.vprfxs, ParameterList.toNameArray(param));
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return;
        }
        this.enc = new Encoder(this.pl);
        if (this.enc.getExitCode() != 0) {
            System.exit(this.enc.getExitCode());
        }
        try {
            this.enc.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (this.enc.getExitCode() != 0) {
                System.exit(this.enc.getExitCode());
            }
        }
    }
}

