/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorizationDecisionQuery
extends SAMLSubjectQuery
implements Cloneable {
    protected String resource = null;
    protected ArrayList actions = new ArrayList();
    protected ArrayList evidence = new ArrayList();

    public SAMLAuthorizationDecisionQuery() {
    }

    public SAMLAuthorizationDecisionQuery(SAMLSubject sAMLSubject, String string, Collection collection, Collection collection2) throws SAMLException {
        super(sAMLSubject);
        Iterator iterator;
        this.resource = XML.assign(string);
        if (collection != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((SAMLAction)iterator.next()).setParent(this));
            }
        }
        if (collection2 != null) {
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SAMLAssertion) {
                    this.evidence.add(((SAMLAssertion)e).setParent(this));
                    continue;
                }
                if (!(e instanceof String) || ((String)e).length() <= 0) continue;
                this.evidence.add(e);
            }
        }
    }

    public SAMLAuthorizationDecisionQuery(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAuthorizationDecisionQuery(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAuthorizationDecisionQuery.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery")) {
            object = XML.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && object != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(((QName)object).getNamespaceURI()) && "AuthorizationDecisionQueryType".equals(((QName)object).getLocalPart()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionQuery.fromDOM() requires samlp:AuthorizationDecisionQuery at root");
            }
        }
        this.resource = XML.assign(element.getAttributeNS(null, "Resource"));
        object = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        while (object != null) {
            this.actions.add(new SAMLAction((Element)object).setParent(this));
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        }
        object = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
        if (object != null) {
            Element element2 = XML.getFirstChildElement((Node)object);
            while (element2 != null) {
                if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                    this.evidence.add(new SAMLAssertion(element2).setParent(this));
                } else if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference") && element2.hasChildNodes()) {
                    this.evidence.add(element2.getFirstChild().getNodeValue());
                }
                element2 = XML.getNextSiblingElement(element2);
            }
        }
        this.checkValidity();
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        this.resource = string;
        this.setDirty(true);
    }

    public Iterator getActions() {
        return this.actions.iterator();
    }

    public void setActions(Collection collection) throws SAMLException {
        this.actions.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((SAMLAction)iterator.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addAction(SAMLAction sAMLAction) throws SAMLException {
        if (sAMLAction == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.actions.add(sAMLAction.setParent(this));
        this.setDirty(true);
    }

    public void removeAction(int n) {
        this.actions.remove(n);
        this.setDirty(true);
    }

    public Iterator getEvidence() {
        return this.evidence.iterator();
    }

    public void setEvidence(Collection collection) throws SAMLException {
        this.evidence.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addEvidence(iterator.next());
            }
        }
        this.setDirty(true);
    }

    public void addEvidence(Object object) throws SAMLException {
        if (object != null && (object instanceof String || object instanceof SAMLAssertion)) {
            if (object instanceof SAMLAssertion) {
                this.evidence.add(((SAMLAssertion)object).setParent(this));
            } else if (((String)object).length() > 0) {
                this.evidence.add(object);
            }
        } else {
            throw new IllegalArgumentException("can only add Strings or SAMLAssertions");
        }
        this.setDirty(true);
    }

    public void removeEvidence(int n) throws IndexOutOfBoundsException {
        this.evidence.remove(n);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            element.setAttributeNS(null, "Resource", this.resource);
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                element.appendChild(((SAMLAction)iterator.next()).toDOM(document));
            }
            if (this.evidence.size() > 0) {
                Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
                iterator = this.evidence.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof SAMLAssertion) {
                        element2.appendChild(((SAMLAssertion)e).toDOM(document, false));
                        continue;
                    }
                    if (!(e instanceof String) || XML.isEmpty((String)e)) continue;
                    element2.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")).appendChild(document.createTextNode((String)e));
                }
                element.appendChild(element2);
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        super.checkValidity();
        if (XML.isEmpty(this.resource) || this.actions.size() == 0) {
            throw new MalformedException("AuthorizationDecisionQuery is invalid, must have Resource and at least one Action");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthorizationDecisionQuery sAMLAuthorizationDecisionQuery = (SAMLAuthorizationDecisionQuery)super.clone();
        try {
            sAMLAuthorizationDecisionQuery.actions = new ArrayList();
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                sAMLAuthorizationDecisionQuery.actions.add(((SAMLAction)((SAMLAction)iterator.next()).clone()).setParent(sAMLAuthorizationDecisionQuery));
            }
            sAMLAuthorizationDecisionQuery.evidence = new ArrayList();
            iterator = this.evidence.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SAMLAssertion) {
                    sAMLAuthorizationDecisionQuery.evidence.add(((SAMLAssertion)((SAMLAssertion)e).clone()).setParent(sAMLAuthorizationDecisionQuery));
                    continue;
                }
                if (!(e instanceof String)) continue;
                sAMLAuthorizationDecisionQuery.evidence.add(e);
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLAuthorizationDecisionQuery;
    }
}

