/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.debugger.ui.PageEntry;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class DocumentEntry {
    private final PDDocument doc;
    private final String filename;

    public DocumentEntry(PDDocument doc, String filename) {
        this.doc = doc;
        this.filename = filename;
    }

    public int getPageCount() {
        return this.doc.getPages().getCount();
    }

    public PageEntry getPage(int index) {
        PDPage page = this.doc.getPages().get(index);
        String pageLabel = PDFDebugger.getPageLabel(this.doc, index);
        return new PageEntry(page.getCOSObject(), index + 1, pageLabel);
    }

    public int indexOf(PageEntry page) {
        return page.getPageNum() - 1;
    }

    public String toString() {
        return this.filename;
    }
}

