/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;

public class PersistentStoreCollectionSession
implements PersistentStoreCollection {
    private final Session session;
    private final LongKeyHashMap rowStoreMapSession = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapTransaction = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapStatement = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapRoutine = new LongKeyHashMap();
    private HsqlDeque rowStoreListStack;
    DataFileCacheSession resultCache;

    public PersistentStoreCollectionSession(Session session) {
        this.session = session;
    }

    @Override
    public synchronized void setStore(Object object, PersistentStore persistentStore) {
        TableBase tableBase = (TableBase)object;
        switch (tableBase.persistenceScope) {
            case 20: {
                if (persistentStore == null) {
                    this.rowStoreMapRoutine.remove(tableBase.getPersistenceId());
                    break;
                }
                this.rowStoreMapRoutine.put(tableBase.getPersistenceId(), persistentStore);
                break;
            }
            case 21: {
                if (persistentStore == null) {
                    this.rowStoreMapStatement.remove(tableBase.getPersistenceId());
                    break;
                }
                this.rowStoreMapStatement.put(tableBase.getPersistenceId(), persistentStore);
                break;
            }
            case 22: 
            case 24: {
                if (persistentStore == null) {
                    this.rowStoreMapTransaction.remove(tableBase.getPersistenceId());
                    break;
                }
                this.rowStoreMapTransaction.put(tableBase.getPersistenceId(), persistentStore);
                break;
            }
            case 23: {
                if (persistentStore == null) {
                    this.rowStoreMapSession.remove(tableBase.getPersistenceId());
                    break;
                }
                this.rowStoreMapSession.put(tableBase.getPersistenceId(), persistentStore);
                break;
            }
            default: {
                throw Error.runtimeError(201, "PersistentStoreCollectionSession");
            }
        }
    }

    public synchronized PersistentStore getViewStore(long l) {
        return (PersistentStore)this.rowStoreMapStatement.get(l);
    }

    @Override
    public synchronized PersistentStore getStore(Object object) {
        TableBase tableBase = (TableBase)object;
        switch (tableBase.persistenceScope) {
            case 20: {
                PersistentStore persistentStore = (PersistentStore)this.rowStoreMapRoutine.get(tableBase.getPersistenceId());
                if (persistentStore == null) {
                    persistentStore = this.session.database.logger.newStore(this.session, this, tableBase);
                }
                return persistentStore;
            }
            case 21: {
                PersistentStore persistentStore = (PersistentStore)this.rowStoreMapStatement.get(tableBase.getPersistenceId());
                if (persistentStore == null) {
                    persistentStore = this.session.database.logger.newStore(this.session, this, tableBase);
                }
                return persistentStore;
            }
            case 22: 
            case 24: {
                PersistentStore persistentStore = (PersistentStore)this.rowStoreMapTransaction.get(tableBase.getPersistenceId());
                if (persistentStore == null) {
                    persistentStore = this.session.database.logger.newStore(this.session, this, tableBase);
                }
                if (tableBase.getTableType() == 1) {
                    this.session.database.dbInfo.setStore(this.session, (Table)tableBase, persistentStore);
                }
                return persistentStore;
            }
            case 23: {
                PersistentStore persistentStore = (PersistentStore)this.rowStoreMapSession.get(tableBase.getPersistenceId());
                if (persistentStore == null) {
                    persistentStore = this.session.database.logger.newStore(this.session, this, tableBase);
                }
                return persistentStore;
            }
        }
        throw Error.runtimeError(201, "PersistentStoreCollectionSession");
    }

    public synchronized void clearAllTables() {
        this.clearSessionTables();
        this.clearTransactionTables();
        this.clearStatementTables();
        this.clearRoutineTables();
        this.closeSessionDataCache();
    }

    public synchronized void clearResultTables(long l) {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapSession.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            if (persistentStore.getTimestamp() != l) continue;
            persistentStore.release();
            iterator.remove();
        }
    }

    public synchronized void clearSessionTables() {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapSession.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMapSession.clear();
    }

    public synchronized void clearTransactionTables() {
        if (this.rowStoreMapTransaction.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapTransaction.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMapTransaction.clear();
    }

    public synchronized void clearStatementTables() {
        if (this.rowStoreMapStatement.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapStatement.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMapStatement.clear();
    }

    public synchronized void clearRoutineTables() {
        if (this.rowStoreMapRoutine.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMapRoutine.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMapRoutine.clear();
    }

    public synchronized void registerIndex(Session session, TableBase tableBase) {
        PersistentStore persistentStore = this.findStore(tableBase);
        if (persistentStore == null) {
            return;
        }
        persistentStore.resetAccessorKeys(session, tableBase.getIndexList());
    }

    public synchronized PersistentStore findStore(TableBase tableBase) {
        PersistentStore persistentStore = null;
        switch (tableBase.persistenceScope) {
            case 20: {
                persistentStore = (PersistentStore)this.rowStoreMapRoutine.get(tableBase.getPersistenceId());
                break;
            }
            case 21: {
                persistentStore = (PersistentStore)this.rowStoreMapStatement.get(tableBase.getPersistenceId());
                break;
            }
            case 22: 
            case 24: {
                persistentStore = (PersistentStore)this.rowStoreMapTransaction.get(tableBase.getPersistenceId());
                break;
            }
            case 23: {
                persistentStore = (PersistentStore)this.rowStoreMapSession.get(tableBase.getPersistenceId());
            }
        }
        return persistentStore;
    }

    public synchronized void moveData(Table table, Table table2, int n, int n2) {
        PersistentStore persistentStore = this.findStore(table);
        if (persistentStore == null) {
            return;
        }
        PersistentStore persistentStore2 = this.getStore(table2);
        try {
            persistentStore2.moveData(this.session, persistentStore, n, n2);
        }
        catch (HsqlException hsqlException) {
            persistentStore2.release();
            this.setStore(table2, null);
            throw hsqlException;
        }
        this.setStore(table, null);
    }

    public synchronized void push(boolean bl) {
        if (this.rowStoreListStack == null) {
            this.rowStoreListStack = new HsqlDeque();
        }
        Object[] objectArray = this.rowStoreMapStatement.toArray();
        this.rowStoreListStack.add(objectArray);
        this.rowStoreMapStatement.clear();
        if (bl) {
            objectArray = this.rowStoreMapRoutine.toArray();
            this.rowStoreListStack.add(objectArray);
            this.rowStoreMapRoutine.clear();
        }
    }

    public synchronized void pop(boolean bl) {
        PersistentStore persistentStore;
        int n;
        Object[] objectArray;
        if (bl) {
            objectArray = (Object[])this.rowStoreListStack.removeLast();
            this.clearRoutineTables();
            for (n = 0; n < objectArray.length; ++n) {
                persistentStore = (PersistentStore)objectArray[n];
                this.rowStoreMapRoutine.put(persistentStore.getTable().getPersistenceId(), persistentStore);
            }
        }
        objectArray = (Object[])this.rowStoreListStack.removeLast();
        this.clearStatementTables();
        for (n = 0; n < objectArray.length; ++n) {
            persistentStore = (PersistentStore)objectArray[n];
            this.rowStoreMapStatement.put(persistentStore.getTable().getPersistenceId(), persistentStore);
        }
    }

    public synchronized DataFileCacheSession getSessionDataCache() {
        if (this.resultCache == null) {
            String string = this.session.database.logger.getTempDirectoryPath();
            if (string == null) {
                return null;
            }
            try {
                this.resultCache = new DataFileCacheSession(this.session.database, string + "/session_" + Long.toString(this.session.getId()));
                this.resultCache.open(false);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return this.resultCache;
    }

    private void closeSessionDataCache() {
        if (this.resultCache != null) {
            try {
                this.resultCache.release();
                this.resultCache.deleteFile();
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.resultCache = null;
        }
    }

    @Override
    public synchronized void release() {
        this.clearAllTables();
    }
}

