/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;

abstract class MeridianArcBased
extends NormalizedProjection {
    private static final long serialVersionUID = 6105123637473385555L;
    private final double cf0;
    private final double cf1;
    private final double cf2;
    private final double cf3;
    private final double cf4;
    private final double ci1;
    private final double ci2;
    private final double ci3;
    private final double ci4;
    private final double r\u00b5;

    MeridianArcBased(Initializer initializer) {
        super(initializer);
        double d = this.eccentricitySquared;
        double d2 = d * d;
        double d3 = d * d2;
        double d4 = d2 * d2;
        double d5 = d * d4;
        this.cf0 = -0.0067291259765625 * d5 + -0.01068115234375 * d4 + -0.01953125 * d3 + -0.046875 * d2 + -0.25 * d + 1.0;
        this.cf1 = 0.01201629638671875 * d5 + 0.01068115234375 * d4 + 0.01953125 * d3 + 0.046875 * d2 + -0.75 * d;
        this.cf2 = -0.080108642578125 * d5 + 0.007120768229166667 * d4 + 0.013020833333333334 * d3 + -0.46875 * d2;
        this.cf3 = 0.35888671875 * d5 + 0.005696614583333333 * d4 + -0.3645833333333333 * d3;
        this.cf4 = -0.538330078125 * d5 + -0.3076171875 * d4;
        this.r\u00b5 = 1.0 - 0.25 * d - 0.046875 * d2 - 0.01953125 * d3;
        DoubleDouble doubleDouble = initializer.axisLengthRatio();
        doubleDouble.ratio_1m_1p();
        double d6 = doubleDouble.doubleValue();
        double d7 = d6 * d6;
        double d8 = d6 * d7;
        double d9 = d7 * d7;
        this.ci1 = 10.265625 * d9 + 7.75 * d8 + 5.25 * d7 + 3.0 * d6;
        this.ci2 = -157.65625 * d9 + -50.333333333333336 * d8 + -10.5 * d7;
        this.ci3 = 411.375 * d9 + 50.333333333333336 * d8;
        this.ci4 = -274.25 * d9;
    }

    MeridianArcBased(MeridianArcBased meridianArcBased) {
        super(meridianArcBased);
        this.cf0 = meridianArcBased.cf0;
        this.cf1 = meridianArcBased.cf1;
        this.cf2 = meridianArcBased.cf2;
        this.cf3 = meridianArcBased.cf3;
        this.cf4 = meridianArcBased.cf4;
        this.ci1 = meridianArcBased.ci1;
        this.ci2 = meridianArcBased.ci2;
        this.ci3 = meridianArcBased.ci3;
        this.ci4 = meridianArcBased.ci4;
        this.r\u00b5 = meridianArcBased.r\u00b5;
    }

    final double distance(double d, double d2, double d3) {
        double d4 = d2 * d2;
        return this.cf0 * d + d3 * d2 * (this.cf1 + d4 * (this.cf2 + d4 * (this.cf3 + d4 * this.cf4)));
    }

    final double dM_d\u03c6(double d) {
        return ((((7.0 - 8.0 * d) * this.cf4 - 6.0 * this.cf3) * d + 5.0 * this.cf3 - 4.0 * this.cf2) * d + 3.0 * this.cf2 - 2.0 * this.cf1) * d + this.cf1 + this.cf0;
    }

    final double latitude(double d) {
        double d2 = d / this.r\u00b5;
        double d3 = Math.sin(d2);
        double d4 = d3 * d3;
        d2 += Math.cos(d2) * d3 * (this.ci1 + d4 * (this.ci2 + d4 * (this.ci3 + d4 * this.ci4)));
        return d2;
    }
}

