/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.shared.TempStoreOutputStreamFactory;

public class BrowserCallContextImpl
extends CallContextImpl {
    private static final long serialVersionUID = 1L;
    private CmisService service;
    private String objectId;
    private String[] pathFragments;
    private String typeId;
    private BaseTypeId baseTypeId;
    private String token;

    public BrowserCallContextImpl(String binding, CmisVersion cmisVersion, String repositoryId, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, CmisServiceFactory factory, TempStoreOutputStreamFactory streamFactory) {
        super(binding, cmisVersion, repositoryId, servletContext, request, response, factory, streamFactory);
    }

    public void setCallDetails(CmisService service, String objectId, String[] pathFragments, String token) {
        this.service = service;
        this.objectId = objectId;
        this.pathFragments = pathFragments;
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public String getObjectId() {
        if (this.objectId != null) {
            return this.objectId;
        }
        this.loadObject();
        return this.objectId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public BaseTypeId getBaseTypeId() {
        if (this.baseTypeId != null) {
            return this.baseTypeId;
        }
        this.loadObject();
        return this.baseTypeId;
    }

    private void loadObject() {
        ObjectData object = null;
        if (this.objectId != null) {
            object = this.service.getObject(this.getRepositoryId(), this.objectId, "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
        } else if (this.pathFragments != null) {
            object = this.service.getObjectByPath(this.getRepositoryId(), this.getPath(), "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
        } else {
            return;
        }
        this.objectId = object.getId();
        this.typeId = this.getStringPropertyValue(object, "cmis:objectTypeId");
        this.baseTypeId = BaseTypeId.fromValue((String)this.getStringPropertyValue(object, "cmis:baseTypeId"));
    }

    private String getPath() {
        if (this.pathFragments.length < 2) {
            throw new CmisRuntimeException("Internal error!");
        }
        if (this.pathFragments.length == 2) {
            return "/";
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 2; i < this.pathFragments.length; ++i) {
            if (this.pathFragments[i].length() == 0) continue;
            sb.append('/');
            sb.append(this.pathFragments[i]);
        }
        return sb.toString();
    }

    protected String getStringPropertyValue(ObjectData object, String name) {
        if (object == null) {
            return null;
        }
        Properties propData = object.getProperties();
        if (propData == null) {
            return null;
        }
        Map properties = propData.getProperties();
        if (properties == null) {
            return null;
        }
        PropertyData property = (PropertyData)properties.get(name);
        if (property == null) {
            return null;
        }
        Object value = property.getFirstValue();
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }
}

