/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

public final class NameValidator {
    public static final String ERROR_ILLEGAL_ID = "Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_'";
    public static final String ERROR_ILLEGAL_NAME = "Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'";

    private NameValidator() {
    }

    public static boolean isValidId(String s) {
        if (null == s || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ':' || c == '.' || c == '-' || c == '_' || c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidLocalName(String s) {
        return NameValidator.isValidId(s);
    }

    public static boolean isValidName(String s) {
        if (null == s || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '/' && c != '\"' && c != ':' && c != '*' && c != '?' && c != '<' && c != '>' && c != '|') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String s) {
        return NameValidator.isValidId(s);
    }

    public static boolean isValidQueryName(String s) {
        return NameValidator.isValidId(s);
    }
}

