/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.TimePeriod;

public class Year
extends TimePeriod {
    private static final long serialVersionUID = 8485456751196062574L;
    private static final boolean DEBUG = false;
    private static final String YEAR_FORMAT = "yyyy";

    public Year() {
        super("P1Y");
        int temp = TimeZone.getDefault().getRawOffset();
        if (temp < 0) {
            temp = -temp;
            try {
                this.setZoneNegative();
            }
            catch (OperationNotSupportedException e) {
                // empty catch block
            }
        }
        short zhour = (short)(temp / 3600000);
        short zmin = (short)((temp %= 3600000) / 60000);
        try {
            this.setZone(zhour, zmin);
        }
        catch (OperationNotSupportedException e) {
            // empty catch block
        }
    }

    public void setMonth(short month) throws OperationNotSupportedException {
        String err = "In a Year : the month field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setDay(short day) throws OperationNotSupportedException {
        String err = "In a Year : the day field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setHour(short hour) throws OperationNotSupportedException {
        String err = "In a Year : the hour field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setMinute(short minute) throws OperationNotSupportedException {
        String err = "In a Year : the minute field must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setSecond(short second, short millsecond) throws OperationNotSupportedException {
        String err = "In a Year : the second fields must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setZone(short hour, short minute) throws OperationNotSupportedException {
        String err = "In a Year : the time zone fields must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        String err = "In a Year : the time zone fields must not be changed";
        throw new OperationNotSupportedException(err);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getCentury());
        if (result.length() == 1) {
            result.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getYear());
        if (this.isNegative()) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Year.parseYear(str);
    }

    public static Year parseYear(String str) throws ParseException {
        Year result = new Year();
        if (str.startsWith("-")) {
            result.setNegative();
            str = str.substring(1);
        }
        if (str.length() != 4) {
            throw new ParseException(str + ": Bad XML Schema Year type format (CCYY)", 0);
        }
        result.setCentury(Short.parseShort(str.substring(0, 2)));
        try {
            result.setYear(Short.parseShort(str.substring(2, 4)));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(YEAR_FORMAT);
        SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
        }
        df.setTimeZone(timeZone);
        date = df.parse(this.toString());
        return date;
    }
}

