/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class MethodExpressionValidator
implements Validator,
StateHolder {
    private MethodExpression methodExpression;
    private boolean isTransient = false;

    public MethodExpressionValidator() {
    }

    public MethodExpressionValidator(MethodExpression methodExpression) {
        if (methodExpression == null) {
            throw new NullPointerException("methodExpression can not be null.");
        }
        this.methodExpression = methodExpression;
    }

    @Override
    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        Object[] params = new Object[]{context, component, value};
        try {
            this.methodExpression.invoke(context.getELContext(), params);
        }
        catch (ELException e) {
            Throwable cause = e.getCause();
            ValidatorException vex = null;
            if (cause != null) {
                do {
                    if (cause == null || !(cause instanceof ValidatorException)) continue;
                    vex = (ValidatorException)cause;
                    break;
                } while ((cause = cause.getCause()) != null);
            }
            if (vex != null) {
                throw vex;
            }
            throw e;
        }
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)state;
    }

    @Override
    public Object saveState(FacesContext context) {
        return this.methodExpression;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }
}

