/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class _NavigationUtils {
    _NavigationUtils() {
    }

    public static Map<String, List<String>> getEvaluatedNavigationParameters(FacesContext facesContext, Map<String, List<String>> parameters) {
        Map<String, List<String>> evaluatedParameters = null;
        if (parameters != null && parameters.size() > 0) {
            evaluatedParameters = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
                boolean containsEL = false;
                for (String value : pair.getValue()) {
                    if (!_NavigationUtils._isExpression(value)) continue;
                    containsEL = true;
                    break;
                }
                if (containsEL) {
                    evaluatedParameters.put(pair.getKey(), _NavigationUtils._evaluateValueExpressions(facesContext, pair.getValue()));
                    continue;
                }
                evaluatedParameters.put(pair.getKey(), pair.getValue());
            }
        } else {
            evaluatedParameters = parameters;
        }
        return evaluatedParameters;
    }

    private static List<String> _evaluateValueExpressions(FacesContext context, List<String> values) {
        ArrayList<String> target = new ArrayList<String>(values.size());
        for (String value : values) {
            if (_NavigationUtils._isExpression(value)) {
                value = context.getApplication().evaluateExpressionGet(context, value, String.class);
            }
            target.add(value);
        }
        return target;
    }

    private static boolean _isExpression(String text) {
        return text.indexOf("#{") != -1;
    }
}

