/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;
import org.apache.myfaces.spi.impl.DefaultFaceletConfigResourceProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FaceletConfigResourceProviderFactory {
    protected static final String FACTORY_DEFAULT = DefaultFaceletConfigResourceProviderFactory.class.getName();
    private static final String FACTORY_KEY = FaceletConfigResourceProviderFactory.class.getName();

    public static FaceletConfigResourceProviderFactory getFacesConfigResourceProviderFactory(ExternalContext ctx) {
        FaceletConfigResourceProviderFactory instance = (FaceletConfigResourceProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        FaceletConfigResourceProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (FaceletConfigResourceProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, FaceletConfigResourceProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (FaceletConfigResourceProviderFactory)SpiUtils.build(ctx, FaceletConfigResourceProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException(pae);
        }
        if (lpf != null) {
            FaceletConfigResourceProviderFactory.setFaceletConfigResourceProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setFaceletConfigResourceProviderFactory(ExternalContext ctx, FaceletConfigResourceProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract FaceletConfigResourceProvider createFaceletConfigResourceProvider(ExternalContext var1);
}

