/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.conversation.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

/**
 * Wire the custom orchestra xml attributes to the appropriate handler classes.
 * <p>
 * This is invoked by spring due to the "magic" files named "spring.handlers" and
 * "spring.schemas" in the META-INF directory.
 * <p>
 * When Spring encounters an attribute in a namespace specified by the above
 * config files it invokes the appropriate bean definition decorator registered
 * by this class. 
 */
public class OrchestraNamespaceHandler extends NamespaceHandlerSupport
{
    public void init()
    {
        registerBeanDefinitionDecoratorForAttribute(
            BeanDefinitionConversationNameAttrDecorator.XSD_CONVERSATION_NAME_ATTRIBUTE,
            new BeanDefinitionConversationNameAttrDecorator());
    }
}
