/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.jsf.filter;

import org.apache.myfaces.orchestra.lib.CompoundFilter;

/**
 * Provides the functionality of two useful orchestra filters together as one, reducing the
 * amount of web.xml configuration required.
 * <p>
 * @deprecated Since Orchestra 1.1, initialisation of Orchestra for JSF requests is
 * handled automatically (via the OrchestraFacesContextFactory). Therefore just the
 * org.apache.myfaces.orchestra.filter.OrchestraServletFilter is needed. Note that
 * if this filter is used with Orchestra1.1, then for JSF requests the FrameworkAdapter
 * is initialised twice: once by this filter, then again by the FacesContextFactory.
 * This does no harm.
 * <p>
 * @see org.apache.myfaces.orchestra.frameworkAdapter.jsf.JsfFrameworkAdapterFilter
 * @see org.apache.myfaces.orchestra.filter.OrchestraServletFilter
 */
public class OrchestraServletFilter extends CompoundFilter
{
    public OrchestraServletFilter()
    {
        super(
            //new org.apache.myfaces.orchestra.frameworkAdapter.jsf.JsfFrameworkAdapterFilter(),
            new org.apache.myfaces.orchestra.lib._NullFilter(),
            new org.apache.myfaces.orchestra.filter.OrchestraServletFilter());
    }
}
