"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.window = void 0;
const chai_1 = require("chai");
const mocha_1 = require("mocha");
const mona_dish_1 = require("mona-dish");
const jsdom = require("jsdom");
const { JSDOM } = jsdom;
const dom = new JSDOM(`
    <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
    </head>
    <body>
        <div />
        <div />
        <div />
        <div />
    </body>
    </html>
    
    `);
exports.window = dom.window;
class Probe {
    constructor() {
        this.val1 = 1;
        this.val2 = 2;
        this.val3 = 3;
    }
}
(0, mocha_1.describe)('Lang tests', () => {
    (0, mocha_1.it)('initializable', () => {
        const lang = mona_dish_1.Lang;
        (0, chai_1.expect)(lang).to.exist;
    });
    (0, mocha_1.it)('strToArray working', () => {
        const lang = mona_dish_1.Lang;
        let arr = lang.strToArray("hello.world.from.me", /\./gi);
        (0, chai_1.expect)(arr).to.exist;
        (0, chai_1.expect)(arr.length).to.eq(4);
        (0, chai_1.expect)(arr[3]).to.eq("me");
    });
    (0, mocha_1.it)('trim working', () => {
        const lang = mona_dish_1.Lang;
        let origStr = " hello world from me    ";
        let trimmed = lang.trim(origStr);
        (0, chai_1.expect)(trimmed).to.exist;
        (0, chai_1.expect)(trimmed).to.eq("hello world from me");
    });
    (0, mocha_1.it)('isString working', () => {
        const lang = mona_dish_1.Lang;
        (0, chai_1.expect)(lang.isString(" ")).to.be.true;
        (0, chai_1.expect)(lang.isString('')).to.be.true;
        (0, chai_1.expect)(lang.isString(null)).to.be.false;
        (0, chai_1.expect)(lang.isString(undefined)).to.be.false;
        (0, chai_1.expect)(lang.isString(function () { return true; })).to.be.false;
        (0, chai_1.expect)(lang.isString(new Probe())).to.be.false;
    });
    (0, mocha_1.it)('isFunc working', () => {
        const lang = mona_dish_1.Lang;
        (0, chai_1.expect)(lang.isFunc(() => { })).to.be.true;
        (0, chai_1.expect)(lang.isFunc(function () { return true; })).to.be.true;
        (0, chai_1.expect)(lang.isFunc("blarg")).to.be.false;
        (0, chai_1.expect)(lang.isFunc(new Probe())).to.be.false;
    });
    (0, mocha_1.it)('objToArray working', () => {
        const lang = mona_dish_1.Lang;
        let obj_probe = new Probe();
        let resultArr = lang.objToArray(obj_probe);
        (0, chai_1.expect)(lang.assertType(resultArr, Array)).to.be.true;
        (0, chai_1.expect)(resultArr.length).to.eq(0);
        obj_probe = exports.window.document.body.querySelectorAll("div");
        resultArr = lang.objToArray(obj_probe);
        (0, chai_1.expect)(resultArr.length).to.eq(4);
        (0, chai_1.expect)(lang.assertType(resultArr, Array)).to.be.true;
    });
    (0, mocha_1.it)('equals ignore case test', () => {
        const lang = mona_dish_1.Lang;
        (0, chai_1.expect)(lang.equalsIgnoreCase(null, null)).to.be.true;
        (0, chai_1.expect)(lang.equalsIgnoreCase("", "")).to.be.true;
        (0, chai_1.expect)(lang.equalsIgnoreCase("null", "NuLL")).to.be.true;
        (0, chai_1.expect)(lang.equalsIgnoreCase("null ", "NuLL")).to.be.false;
        (0, chai_1.expect)(lang.equalsIgnoreCase("null", "NuLL2")).to.be.false;
    });
});
//# sourceMappingURL=LangTest.spec.js.map