/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk.mapreduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.CompoundAssignmentTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.LambdaExpressionTree;
import jpt.sun.source.tree.MemberReferenceTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.UnaryTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jdk.mapreduce.PreconditionsChecker;
import org.netbeans.modules.java.hints.jdk.mapreduce.TreeUtilities;

class ProspectiveOperation {
    private static final String UNKNOWN_NAME = "_item";
    private boolean isUnmodifiable;
    private OperationType opType;
    private Tree correspondingTree;
    private final Set<Name> innerLoopVariables;
    private final TreeMaker treeMaker;
    private final CompilationInfo workingCopy;
    private final Map<Name, String> varToType;
    private ExpressionTree reducingVariable;
    Set<Name> neededVariables;
    Set<Name> availableVariables;

    private static boolean isLong(ExpressionTree reducing, WorkingCopy workingCopy) {
        return ProspectiveOperation.isType(reducing, workingCopy, "java.lang.Long");
    }

    private static boolean isChar(ExpressionTree reducing, WorkingCopy workingCopy) {
        return ProspectiveOperation.isType(reducing, workingCopy, "java.lang.Character");
    }

    private static List<ProspectiveOperation> createProspectiveReducer(StatementTree tree, WorkingCopy workingCopy, OperationType operationType, PreconditionsChecker precond, List<ProspectiveOperation> ls) throws IllegalStateException {
        ExpressionTree expr = ((ExpressionStatementTree)tree).getExpression();
        TreeMaker tm = workingCopy.getTreeMaker();
        ProspectiveOperation redOp = null;
        Tree.Kind opKind = expr.getKind();
        if (TreeUtilities.isCompoundAssignementAssignement(opKind)) {
            redOp = ProspectiveOperation.handleCompoundAssignementReducer(tm, expr, operationType, precond, workingCopy, ls, redOp);
        } else if (TreeUtilities.isPreOrPostfixOp(opKind)) {
            redOp = ProspectiveOperation.handlePreOrPostFixReducer(expr, workingCopy, tm, operationType, precond, ls, redOp);
        }
        ls.add(redOp);
        return ls;
    }

    private static ProspectiveOperation handleCompoundAssignementReducer(TreeMaker tm, ExpressionTree expr, OperationType operationType, PreconditionsChecker precond, WorkingCopy workingCopy, List<ProspectiveOperation> ls, ProspectiveOperation redOp) {
        VariableTree var = tm.Variable(tm.Modifiers(EnumSet.noneOf(Modifier.class)), "dummyVar18912", tm.Type("Object"), ((CompoundAssignmentTree)expr).getExpression());
        ProspectiveOperation map = new ProspectiveOperation(var, OperationType.MAP, precond.getInnerVariables(), workingCopy, precond.getVarToName());
        map.getAvailableVariables().add(var.getName());
        ls.add(map);
        redOp = new ProspectiveOperation(expr, operationType, precond.getInnerVariables(), workingCopy, precond.getVarToName());
        redOp.neededVariables = new HashSet<Name>();
        redOp.neededVariables.add(var.getName());
        redOp.reducingVariable = ((CompoundAssignmentTree)expr).getVariable();
        return redOp;
    }

    private static ProspectiveOperation handlePreOrPostFixReducer(ExpressionTree expr, WorkingCopy workingCopy, TreeMaker tm, OperationType operationType, PreconditionsChecker precond, List<ProspectiveOperation> ls, ProspectiveOperation redOp) {
        ExpressionTree reducing = ((UnaryTree)expr).getExpression();
        ProspectiveOperation map = ProspectiveOperation.isInteger(reducing, workingCopy) || ProspectiveOperation.isLong(reducing, workingCopy) || ProspectiveOperation.isChar(reducing, workingCopy) ? new ProspectiveOperation(tm.Literal(1), OperationType.MAP, precond.getInnerVariables(), workingCopy, precond.getVarToName()) : new ProspectiveOperation(tm.Literal(1.0), OperationType.MAP, precond.getInnerVariables(), workingCopy, precond.getVarToName());
        ls.add(map);
        redOp = new ProspectiveOperation(expr, operationType, precond.getInnerVariables(), workingCopy, precond.getVarToName());
        redOp.reducingVariable = reducing;
        return redOp;
    }

    private Tree blockify(StatementTree correspondingTree) {
        return this.treeMaker.Block(Arrays.asList(correspondingTree), false);
    }

    public Boolean isLazy() {
        return this.opType == OperationType.MAP || this.opType == OperationType.FILTER;
    }

    private Boolean isMergeable() {
        return this.opType == OperationType.FOREACH || this.opType == OperationType.MAP || this.opType == OperationType.FILTER;
    }

    boolean shouldReturn() {
        return this.opType == OperationType.ANYMATCH || this.opType == OperationType.NONEMATCH;
    }

    boolean shouldAssign() {
        return this.opType == OperationType.REDUCE;
    }

    private Set<Name> buildAvailables(PreconditionsChecker.VariablesVisitor treeVariableVisitor) {
        Set<Name> allVariablesUsedInCurrentOp = treeVariableVisitor.getAllLocalVariablesUsed();
        Set<Name> allVariablesDeclaredInCurrentOp = treeVariableVisitor.getInnervariables();
        allVariablesUsedInCurrentOp.addAll(allVariablesDeclaredInCurrentOp);
        return allVariablesUsedInCurrentOp;
    }

    private Set<Name> buildNeeded(PreconditionsChecker.VariablesVisitor treeVariableVisitor) {
        Set<Name> allVariablesUsedInCurrentOp = treeVariableVisitor.getAllLocalVariablesUsed();
        allVariablesUsedInCurrentOp.removeAll(treeVariableVisitor.getInnervariables());
        allVariablesUsedInCurrentOp.retainAll(this.innerLoopVariables);
        return allVariablesUsedInCurrentOp;
    }

    private StatementTree castToStatementTree(Tree currentTree) {
        if (currentTree instanceof StatementTree) {
            return (StatementTree)currentTree;
        }
        return this.treeMaker.ExpressionStatement((ExpressionTree)currentTree);
    }

    private Tree.Kind getSuitableOperator(Tree.Kind kind) {
        if (Tree.Kind.AND_ASSIGNMENT == kind) {
            return Tree.Kind.AND;
        }
        if (Tree.Kind.OR_ASSIGNMENT == kind) {
            return Tree.Kind.OR;
        }
        if (Tree.Kind.PLUS_ASSIGNMENT == kind) {
            return Tree.Kind.PLUS;
        }
        if (Tree.Kind.MINUS_ASSIGNMENT == kind) {
            return Tree.Kind.MINUS;
        }
        if (Tree.Kind.DIVIDE_ASSIGNMENT == kind) {
            return Tree.Kind.DIVIDE;
        }
        if (Tree.Kind.MULTIPLY_ASSIGNMENT == kind) {
            return Tree.Kind.MULTIPLY;
        }
        if (Tree.Kind.REMAINDER_ASSIGNMENT == kind) {
            return Tree.Kind.REMAINDER;
        }
        if (Tree.Kind.LEFT_SHIFT_ASSIGNMENT == kind) {
            return Tree.Kind.LEFT_SHIFT;
        }
        if (Tree.Kind.RIGHT_SHIFT_ASSIGNMENT == kind) {
            return Tree.Kind.RIGHT_SHIFT;
        }
        if (Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT == kind) {
            return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
        }
        return null;
    }

    private boolean isString(ExpressionTree reducingVariable) {
        TypeMirror tm = this.workingCopy.getTrees().getTypeMirror(TreePath.getPath(this.workingCopy.getCompilationUnit(), (Tree)this.reducingVariable));
        return tm != null && tm.toString().equals("java.lang.String");
    }

    private static boolean isInteger(ExpressionTree reducingVariable, CompilationInfo workingCopy) {
        return ProspectiveOperation.isType(reducingVariable, workingCopy, "java.lang.Integer");
    }

    private static boolean isType(ExpressionTree reducingVariable, CompilationInfo workingCopy, String fqn) {
        TypeMirror tm = workingCopy.getTrees().getTypeMirror(TreePath.getPath(workingCopy.getCompilationUnit(), (Tree)reducingVariable));
        TypeElement typeEl = workingCopy.getElements().getTypeElement(fqn);
        if (typeEl != null) {
            TypeMirror integer = typeEl.asType();
            if (tm != null && workingCopy.getTypeUtilities().isCastable(tm, integer)) {
                return true;
            }
        }
        return false;
    }

    private boolean isNumericLiteral(Tree currentTree) {
        Tree.Kind kind = currentTree.getKind();
        return kind == Tree.Kind.INT_LITERAL || kind == Tree.Kind.CHAR_LITERAL || kind == Tree.Kind.DOUBLE_LITERAL || kind == Tree.Kind.FLOAT_LITERAL || kind == Tree.Kind.LONG_LITERAL;
    }

    private void beautifyBlock(Tree currentTree, Set<Name> needed) {
        BlockTree currentBlock = (BlockTree)currentTree;
        if (currentBlock.getStatements().size() == 1) {
            this.correspondingTree = currentBlock.getStatements().get(0);
            this.beautify(needed);
        } else {
            this.correspondingTree = this.addReturn(currentBlock, this.getOneFromSet(needed));
        }
    }

    private void beautifyVariable(Tree currentTree, Set<Name> needed) {
        VariableTree varTree = (VariableTree)currentTree;
        this.correspondingTree = needed.contains(varTree.getName()) ? (varTree.getInitializer() != null ? this.treeMaker.ExpressionStatement(varTree.getInitializer()) : null) : this.addReturn(this.castToStatementTree(currentTree), this.getOneFromSet(needed));
    }

    private void beautifyAssignement(Tree currentTree, Set<Name> needed) {
        IdentifierTree id;
        AssignmentTree assigned = (AssignmentTree)((ExpressionStatementTree)currentTree).getExpression();
        ExpressionTree variable = assigned.getVariable();
        this.correspondingTree = variable.getKind() == Tree.Kind.IDENTIFIER ? (needed.contains((id = (IdentifierTree)variable).getName()) ? this.treeMaker.ExpressionStatement(assigned.getExpression()) : this.addReturn(this.castToStatementTree(currentTree), this.getOneFromSet(needed))) : this.addReturn(this.castToStatementTree(currentTree), this.getOneFromSet(needed));
    }

    private Tree getLambdaForMap() {
        Tree lambdaBody = this.isNumericLiteral(this.correspondingTree) ? this.correspondingTree : ((ExpressionStatementTree)this.correspondingTree).getExpression();
        return lambdaBody;
    }

    private List<ExpressionTree> getArgumentsForReducer() {
        ExpressionTree lambda;
        Tree.Kind opKind = this.correspondingTree.getKind();
        ArrayList<ExpressionTree> args = new ArrayList<ExpressionTree>();
        args.add(this.reducingVariable);
        if (TreeUtilities.isPreOrPostfixOp(opKind)) {
            Object type = null;
            VariableTree var = this.treeMaker.Variable(this.treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), "accumulator", null, null);
            VariableTree var1 = this.makeUnknownVariable();
            if (opKind == Tree.Kind.POSTFIX_INCREMENT || opKind == Tree.Kind.PREFIX_INCREMENT) {
                if (ProspectiveOperation.isInteger(this.reducingVariable, this.workingCopy)) {
                    lambda = this.makeIntegerSumReducer();
                } else {
                    BinaryTree lambdaBody = this.treeMaker.Binary(Tree.Kind.PLUS, this.treeMaker.Identifier("accumulator"), this.treeMaker.Literal(1));
                    lambda = this.treeMaker.LambdaExpression(Arrays.asList(var, var1), lambdaBody);
                }
            } else {
                BinaryTree lambdaBody = this.treeMaker.Binary(Tree.Kind.MINUS, this.treeMaker.Identifier("accumulator"), this.treeMaker.Literal(1));
                lambda = this.treeMaker.LambdaExpression(Arrays.asList(var, var1), lambdaBody);
            }
        } else {
            if (TreeUtilities.isCompoundAssignementAssignement(opKind)) {
                Object type = null;
                VariableTree var = this.treeMaker.Variable(this.treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), "accumulator", null, null);
                VariableTree var1 = this.makeUnknownVariable();
                ExpressionTree lambda2 = opKind == Tree.Kind.PLUS_ASSIGNMENT ? (this.isString(this.reducingVariable) ? this.makeStringConcatReducer() : (ProspectiveOperation.isInteger(this.reducingVariable, this.workingCopy) ? this.makeIntegerSumReducer() : this.makeSimpleExplicitReducer(opKind, var, var1))) : this.makeSimpleExplicitReducer(opKind, var, var1);
                args.add(lambda2);
                return args;
            }
            return null;
        }
        args.add(lambda);
        return args;
    }

    private VariableTree getLambdaArguments() {
        VariableTree var;
        if (this.getNeededVariables().isEmpty()) {
            var = this.makeUnknownVariable();
        } else {
            Name varName = this.getOneFromSet(this.neededVariables);
            Tree type = null;
            var = this.treeMaker.Variable(this.treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), varName.toString(), type, null);
        }
        return var;
    }

    private ExpressionTree makeSimpleExplicitReducer(Tree.Kind opKind, VariableTree var, VariableTree var1) {
        BinaryTree lambdaBody = this.treeMaker.Binary(this.getSuitableOperator(opKind), this.treeMaker.Identifier("accumulator"), this.treeMaker.Identifier(UNKNOWN_NAME));
        LambdaExpressionTree lambda = this.treeMaker.LambdaExpression(Arrays.asList(var, var1), lambdaBody);
        return lambda;
    }

    private MemberReferenceTree makeIntegerSumReducer() {
        return this.treeMaker.MemberReference(MemberReferenceTree.ReferenceMode.INVOKE, this.treeMaker.Identifier("Integer"), "sum", new ArrayList());
    }

    private MemberReferenceTree makeStringConcatReducer() {
        return this.treeMaker.MemberReference(MemberReferenceTree.ReferenceMode.INVOKE, this.treeMaker.Identifier("String"), "concat", new ArrayList());
    }

    private VariableTree makeUnknownVariable() {
        return this.treeMaker.Variable(this.treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), UNKNOWN_NAME, null, null);
    }

    private ProspectiveOperation(Tree tree, OperationType operationType, Set<Name> innerLoopVariables, WorkingCopy workingCopy, Map<Name, String> varToType) {
        this.opType = operationType;
        this.correspondingTree = tree;
        this.innerLoopVariables = innerLoopVariables;
        this.treeMaker = workingCopy.getTreeMaker();
        this.workingCopy = workingCopy;
        this.varToType = varToType;
    }

    public static List<ProspectiveOperation> createOperator(StatementTree tree, OperationType operationType, PreconditionsChecker precond, WorkingCopy workingCopy) {
        ArrayList<ProspectiveOperation> ls = new ArrayList<ProspectiveOperation>();
        if (OperationType.REDUCE == operationType) {
            return ProspectiveOperation.createProspectiveReducer(tree, workingCopy, operationType, precond, ls);
        }
        ProspectiveOperation operation = new ProspectiveOperation(tree, operationType, precond.getInnerVariables(), workingCopy, precond.getVarToName());
        operation.getNeededVariables();
        ls.add(operation);
        return ls;
    }

    public static List<ProspectiveOperation> mergeIntoComposableOperations(List<ProspectiveOperation> ls) {
        List<ProspectiveOperation> result = ProspectiveOperation.mergeRecursivellyIntoComposableOperations(ls);
        if (result == null || result.contains(null)) {
            return null;
        }
        return result;
    }

    private static List<ProspectiveOperation> mergeRecursivellyIntoComposableOperations(List<ProspectiveOperation> ls) {
        for (int i = ls.size() - 1; i > 0; --i) {
            ProspectiveOperation prev;
            ProspectiveOperation current = ls.get(i);
            if (ProspectiveOperation.areComposable(current, prev = ls.get(i - 1))) continue;
            if (!current.isMergeable().booleanValue() || !prev.isMergeable().booleanValue()) {
                return null;
            }
            if (current.opType == OperationType.FILTER || prev.opType == OperationType.FILTER) {
                int lengthOfLs;
                while ((lengthOfLs = ls.size()) > i) {
                    ProspectiveOperation last = ls.get(lengthOfLs - 1);
                    ProspectiveOperation nlast = ls.get(lengthOfLs - 2);
                    ls.remove(lengthOfLs - 1);
                    nlast.merge(last);
                }
                continue;
            }
            prev.merge(current);
            ls.remove(i);
        }
        ProspectiveOperation.beautify(ls);
        return ls;
    }

    private static void beautify(List<ProspectiveOperation> ls) {
        for (int i = ls.size() - 1; i > 0; --i) {
            ProspectiveOperation current = ls.get(i - 1);
            ProspectiveOperation next = ls.get(i);
            Set<Name> needed = next.getNeededVariables();
            current.beautify(needed);
        }
        Iterator<ProspectiveOperation> it = ls.iterator();
        while (it.hasNext()) {
            if (it.next().correspondingTree != null) continue;
            it.remove();
        }
    }

    public Tree getCorrespondingTree() {
        return this.correspondingTree;
    }

    public void eagerize() {
        if (this.opType == OperationType.MAP) {
            this.opType = OperationType.FOREACH;
        }
    }

    private void beautify(Set<Name> needed) {
        if (this.opType == OperationType.MAP) {
            this.beautifyLazy(needed);
        }
    }

    private void beautifyLazy(Set<Name> needed) {
        if (needed.isEmpty()) {
            if (!this.getNeededVariables().isEmpty()) {
                this.beautify(this.getNeededVariables());
            } else {
                HashSet<Name> newSet = new HashSet<Name>();
                newSet.add(null);
                this.beautifyLazy(newSet);
            }
        } else {
            Tree currentTree = this.correspondingTree;
            if (currentTree.getKind() == Tree.Kind.BLOCK) {
                this.beautifyBlock(currentTree, needed);
            } else if (currentTree.getKind() == Tree.Kind.VARIABLE) {
                this.beautifyVariable(currentTree, needed);
            } else if (currentTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && ((ExpressionStatementTree)currentTree).getExpression().getKind() == Tree.Kind.ASSIGNMENT) {
                this.beautifyAssignement(currentTree, needed);
            } else if (!this.isNumericLiteral(currentTree)) {
                this.correspondingTree = this.addReturn(this.castToStatementTree(currentTree), this.getOneFromSet(needed));
            }
        }
    }

    private BlockTree addReturn(StatementTree statement, Name varName) {
        ArrayList<? extends StatementTree> ls = new ArrayList<StatementTree>();
        if (statement.getKind() == Tree.Kind.BLOCK) {
            ls.addAll(((BlockTree)statement).getStatements());
        } else {
            ls.add(statement);
        }
        if (varName != null) {
            ls.add(this.treeMaker.Return(this.treeMaker.Identifier(varName.toString())));
        } else {
            ls.add(this.treeMaker.Return(this.treeMaker.Identifier(UNKNOWN_NAME)));
        }
        return this.treeMaker.Block(ls, false);
    }

    String getSuitableMethod() {
        if (this.opType == OperationType.FOREACH) {
            return "forEachOrdered";
        }
        if (this.opType == OperationType.MAP) {
            return "map";
        }
        if (this.opType == OperationType.FILTER) {
            return "filter";
        }
        if (this.opType == OperationType.ANYMATCH) {
            return "anyMatch";
        }
        if (this.opType == OperationType.NONEMATCH) {
            return "noneMatch";
        }
        return "reduce";
    }

    List<ExpressionTree> getArguments() {
        Tree lambdaBody;
        if (this.correspondingTree.getKind() == Tree.Kind.BLOCK) {
            lambdaBody = this.correspondingTree;
        } else if (this.opType == OperationType.FILTER || this.opType == OperationType.ANYMATCH || this.opType == OperationType.NONEMATCH) {
            lambdaBody = ((IfTree)this.correspondingTree).getCondition();
        } else if (this.opType == OperationType.MAP) {
            lambdaBody = this.getLambdaForMap();
        } else if (this.opType == OperationType.FOREACH) {
            lambdaBody = this.blockify(this.castToStatementTree(this.correspondingTree));
        } else {
            return this.getArgumentsForReducer();
        }
        VariableTree var = this.getLambdaArguments();
        LambdaExpressionTree lambda = this.treeMaker.LambdaExpression(Arrays.asList(var), lambdaBody);
        ArrayList<ExpressionTree> args = new ArrayList<ExpressionTree>();
        args.add(lambda);
        return args;
    }

    private Name getOneFromSet(Set<Name> needed) {
        return needed.iterator().next();
    }

    public void merge(ProspectiveOperation op) {
        if (this.opType == OperationType.FILTER) {
            this.opType = op.opType;
            IfTree ifTree = this.treeMaker.If(((IfTree)this.correspondingTree).getCondition(), (StatementTree)op.correspondingTree, null);
            this.correspondingTree = ifTree;
        } else {
            this.opType = op.opType;
            ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
            if (this.correspondingTree.getKind() == Tree.Kind.BLOCK) {
                statements.addAll(((BlockTree)this.correspondingTree).getStatements());
            } else {
                statements.add(this.castToStatementTree(this.correspondingTree));
            }
            if (op.correspondingTree.getKind() == Tree.Kind.BLOCK) {
                statements.addAll(((BlockTree)op.correspondingTree).getStatements());
            } else {
                statements.add(this.castToStatementTree(op.correspondingTree));
            }
            HashSet<Name> futureAvailable = new HashSet<Name>();
            HashSet<Name> futureNeeded = new HashSet<Name>();
            futureAvailable.addAll(this.getAvailableVariables());
            futureAvailable.addAll(op.getAvailableVariables());
            futureNeeded.addAll(op.getNeededVariables());
            futureNeeded.removeAll(this.getAvailableVariables());
            futureNeeded.addAll(this.getNeededVariables());
            this.neededVariables = futureNeeded;
            this.availableVariables = futureAvailable;
            this.correspondingTree = this.treeMaker.Block(statements, false);
        }
    }

    private static boolean areComposable(ProspectiveOperation current, ProspectiveOperation prev) {
        Set<Name> needed = current.getNeededVariables();
        return needed.size() <= 1 && prev.areAvailableVariables(needed) != false;
    }

    private Set<Name> getAvailableVariables() {
        if (this.availableVariables == null) {
            PreconditionsChecker.VariablesVisitor treeVariableVisitor = new PreconditionsChecker.VariablesVisitor(new TreePath(this.workingCopy.getCompilationUnit()));
            if (this.correspondingTree.getKind() == Tree.Kind.VARIABLE) {
                treeVariableVisitor.scan(((VariableTree)this.correspondingTree).getInitializer(), this.workingCopy.getTrees());
                this.availableVariables = this.buildAvailables(treeVariableVisitor);
                this.availableVariables.add(((VariableTree)this.correspondingTree).getName());
            } else {
                treeVariableVisitor.scan(this.correspondingTree, this.workingCopy.getTrees());
                this.availableVariables = this.buildAvailables(treeVariableVisitor);
            }
        }
        if (this.opType == OperationType.FILTER) {
            return this.getNeededVariables();
        }
        return this.availableVariables;
    }

    public String getTypeForVar(Name varName) {
        return this.varToType.get(varName);
    }

    public Set<Name> getNeededVariables() {
        if (this.neededVariables == null) {
            if (this.opType == OperationType.REDUCE) {
                return new HashSet<Name>();
            }
            PreconditionsChecker.VariablesVisitor treeVariableVisitor = new PreconditionsChecker.VariablesVisitor(new TreePath(this.workingCopy.getCompilationUnit()));
            if (this.correspondingTree.getKind() == Tree.Kind.VARIABLE) {
                treeVariableVisitor.scan(((VariableTree)this.correspondingTree).getInitializer(), this.workingCopy.getTrees());
            } else {
                treeVariableVisitor.scan(this.correspondingTree, this.workingCopy.getTrees());
            }
            this.neededVariables = this.buildNeeded(treeVariableVisitor);
        }
        return this.neededVariables;
    }

    public Boolean areAvailableVariables(Set<Name> needed) {
        Set<Name> available = this.getAvailableVariables();
        if (available.isEmpty()) {
            available.addAll(needed);
            this.getNeededVariables().addAll(needed);
            return true;
        }
        return available.containsAll(needed);
    }

    public boolean isForeach() {
        return this.opType == OperationType.FOREACH;
    }

    public static enum OperationType {
        MAP,
        FOREACH,
        FILTER,
        REDUCE,
        ANYMATCH,
        NONEMATCH;

    }
}

