/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.jdbc.kernel.UpdateManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.Strategy;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;

public abstract class AbstractUpdateManager
implements UpdateManager,
Configurable {
    protected JDBCConfiguration conf = null;
    protected DBDictionary dict = null;

    @Override
    public void setConfiguration(Configuration conf) {
        this.conf = (JDBCConfiguration)conf;
        this.dict = this.conf.getDBDictionaryInstance();
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection flush(Collection states, JDBCStore store) {
        Connection conn = store.getConnection();
        try {
            PreparedStatementManager psMgr = this.newPreparedStatementManager(store, conn);
            Collection collection = this.flush(states, store, psMgr);
            return collection;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    protected Collection flush(Collection states, JDBCStore store, PreparedStatementManager psMgr) {
        RowManager rowMgr = this.newRowManager();
        LinkedList customs = new LinkedList();
        Collection exceps = psMgr.getExceptions();
        ArrayList<StateManagerImpl> mappedByIdStates = new ArrayList<StateManagerImpl>();
        for (OpenJPAStateManager obj : states) {
            if (obj instanceof StateManagerImpl) {
                StateManagerImpl sm = (StateManagerImpl)obj;
                if (sm.getMappedByIdFields() != null) {
                    mappedByIdStates.add(sm);
                    continue;
                }
                exceps = this.populateRowManager(sm, rowMgr, store, exceps, customs);
                continue;
            }
            exceps = this.populateRowManager(obj, rowMgr, store, exceps, customs);
        }
        exceps = this.flush(rowMgr, psMgr, exceps);
        if (mappedByIdStates.size() != 0) {
            for (StateManagerImpl sm : mappedByIdStates) {
                exceps = this.populateRowManager(sm, rowMgr, store, exceps, customs);
            }
            exceps = this.flush(rowMgr, psMgr, exceps);
        }
        Iterator itr = customs.iterator();
        while (itr.hasNext()) {
            try {
                ((CustomMapping)itr.next()).execute(store);
            }
            catch (SQLException se) {
                exceps = this.addException(exceps, SQLExceptions.getStore(se, this.dict));
            }
            catch (OpenJPAException ke) {
                exceps = this.addException(exceps, ke);
            }
        }
        return exceps;
    }

    protected abstract RowManager newRowManager();

    protected abstract PreparedStatementManager newPreparedStatementManager(JDBCStore var1, Connection var2);

    protected abstract Collection flush(RowManager var1, PreparedStatementManager var2, Collection var3);

    protected Collection populateRowManager(OpenJPAStateManager sm, RowManager rowMgr, JDBCStore store, Collection exceps, Collection customs) {
        int action = 0;
        try {
            if (sm.getPCState() == PCState.PNEW && !sm.isFlushed()) {
                action = 1;
                this.insert(sm, (ClassMapping)sm.getMetaData(), rowMgr, store, customs);
            } else if (sm.getPCState() == PCState.PNEWFLUSHEDDELETED || sm.getPCState() == PCState.PDELETED) {
                action = 2;
                this.delete(sm, (ClassMapping)sm.getMetaData(), rowMgr, store, customs);
            } else {
                BitSet dirty = ImplHelper.getUpdateFields(sm);
                if (dirty != null) {
                    this.update(sm, dirty, (ClassMapping)sm.getMetaData(), rowMgr, store, customs, false);
                } else if (sm.isVersionUpdateRequired()) {
                    this.updateIndicators(sm, (ClassMapping)sm.getMetaData(), rowMgr, store, customs, true);
                } else if (sm.isVersionCheckRequired() && !((ClassMapping)sm.getMetaData()).getVersion().checkVersion(sm, store, false)) {
                    exceps = this.addException(exceps, new OptimisticException(sm.getManagedInstance()));
                }
            }
        }
        catch (SQLException se) {
            exceps = this.addException(exceps, SQLExceptions.getStore(se, this.dict));
        }
        catch (OpenJPAException ke) {
            RowImpl row = (RowImpl)rowMgr.getRow(((ClassMapping)sm.getMetaData()).getTable(), action, sm, false);
            if (row != null) {
                row.setFlushed(true);
            }
            exceps = this.addException(exceps, ke);
        }
        return exceps;
    }

    protected Collection addException(Collection exceps, Exception err) {
        if (exceps == null) {
            exceps = new LinkedList<Exception>();
        }
        exceps.add(err);
        return exceps;
    }

    protected void insert(OpenJPAStateManager sm, ClassMapping mapping, RowManager rowMgr, JDBCStore store, Collection customs) throws SQLException {
        Boolean custom = mapping.isCustomInsert(sm, store);
        if (!Boolean.FALSE.equals(custom)) {
            mapping.customInsert(sm, store);
        }
        if (Boolean.TRUE.equals(custom)) {
            return;
        }
        ClassMapping sup = mapping.getJoinablePCSuperclassMapping();
        if (sup != null) {
            this.insert(sm, sup, rowMgr, store, customs);
        }
        mapping.insert(sm, store, rowMgr);
        FieldMapping[] fields = mapping.getDefinedFieldMappings();
        if (((StateManagerImpl)sm).getMappedByIdFields() != null) {
            fields = this.reorderFields(fields);
        }
        BitSet dirty = sm.getDirty();
        for (int i = 0; i < fields.length; ++i) {
            if (!dirty.get(fields[i].getIndex()) || this.bufferCustomInsert(fields[i], sm, store, customs)) continue;
            fields[i].insert(sm, store, rowMgr);
        }
        if (sup == null) {
            Discriminator dsc;
            Version vers = mapping.getVersion();
            if (!this.bufferCustomInsert(vers, sm, store, customs)) {
                vers.insert(sm, store, rowMgr);
            }
            if (!this.bufferCustomInsert(dsc = mapping.getDiscriminator(), sm, store, customs)) {
                dsc.insert(sm, store, rowMgr);
            }
        }
    }

    private FieldMapping[] reorderFields(FieldMapping[] fields) {
        int i;
        ArrayList<FieldMapping> pkFmds = new ArrayList<FieldMapping>();
        FieldMapping[] ret = new FieldMapping[fields.length];
        int j = 0;
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].isPrimaryKey()) {
                ret[j++] = fields[i];
                continue;
            }
            pkFmds.add(fields[i]);
        }
        for (i = 0; i < pkFmds.size(); ++i) {
            ret[j++] = (FieldMapping)pkFmds.get(i);
        }
        return ret;
    }

    private boolean bufferCustomInsert(Strategy strat, OpenJPAStateManager sm, JDBCStore store, Collection customs) {
        Boolean custom = strat.isCustomInsert(sm, store);
        if (!Boolean.FALSE.equals(custom)) {
            customs.add(new CustomMapping(0, sm, strat));
        }
        return Boolean.TRUE.equals(custom);
    }

    protected void delete(OpenJPAStateManager sm, ClassMapping mapping, RowManager rowMgr, JDBCStore store, Collection customs) throws SQLException {
        Boolean custom = mapping.isCustomDelete(sm, store);
        if (!Boolean.FALSE.equals(custom)) {
            mapping.customDelete(sm, store);
        }
        if (Boolean.TRUE.equals(custom)) {
            return;
        }
        FieldMapping[] fields = mapping.getDefinedFieldMappings();
        for (int i = 0; i < fields.length; ++i) {
            if (this.bufferCustomDelete(fields[i], sm, store, customs)) continue;
            fields[i].delete(sm, store, rowMgr);
        }
        ClassMapping sup = mapping.getJoinablePCSuperclassMapping();
        if (sup == null) {
            Discriminator dsc;
            Version vers = mapping.getVersion();
            if (!this.bufferCustomDelete(vers, sm, store, customs)) {
                vers.delete(sm, store, rowMgr);
            }
            if (!this.bufferCustomDelete(dsc = mapping.getDiscriminator(), sm, store, customs)) {
                dsc.delete(sm, store, rowMgr);
            }
        }
        mapping.delete(sm, store, rowMgr);
        if (sup != null) {
            this.delete(sm, sup, rowMgr, store, customs);
        }
    }

    private boolean bufferCustomDelete(Strategy strat, OpenJPAStateManager sm, JDBCStore store, Collection customs) {
        Boolean custom = strat.isCustomDelete(sm, store);
        if (!Boolean.FALSE.equals(custom)) {
            customs.add(new CustomMapping(3, sm, strat));
        }
        return Boolean.TRUE.equals(custom);
    }

    protected void update(OpenJPAStateManager sm, BitSet dirty, ClassMapping mapping, RowManager rowMgr, JDBCStore store, Collection customs, boolean updateIndicators) throws SQLException {
        Boolean custom = mapping.isCustomUpdate(sm, store);
        if (!Boolean.FALSE.equals(custom)) {
            mapping.customUpdate(sm, store);
        }
        if (Boolean.TRUE.equals(custom)) {
            return;
        }
        FieldMapping[] fields = mapping.getDefinedFieldMappings();
        block0: for (int i = 0; i < fields.length; ++i) {
            FieldMapping field = fields[i];
            if (!dirty.get(field.getIndex()) || this.bufferCustomUpdate(field, sm, store, customs)) continue;
            field.update(sm, store, rowMgr);
            if (updateIndicators) continue;
            FieldMapping[] inverseFieldMappings = field.getInverseMappings();
            if (inverseFieldMappings.length == 0) {
                updateIndicators = true;
                continue;
            }
            for (FieldMapping inverseFieldMapping : inverseFieldMappings) {
                if (inverseFieldMapping.getMappedBy() == null) continue;
                updateIndicators = true;
                continue block0;
            }
        }
        ClassMapping sup = mapping.getJoinablePCSuperclassMapping();
        if (sup == null) {
            if (updateIndicators) {
                this.updateIndicators(sm, mapping, rowMgr, store, customs, false);
            }
        } else {
            this.update(sm, dirty, sup, rowMgr, store, customs, updateIndicators);
        }
        mapping.update(sm, store, rowMgr);
    }

    protected void updateIndicators(OpenJPAStateManager sm, ClassMapping mapping, RowManager rowMgr, JDBCStore store, Collection customs, boolean versionUpdateOnly) throws SQLException {
        while (mapping.getJoinablePCSuperclassMapping() != null) {
            mapping = mapping.getJoinablePCSuperclassMapping();
        }
        Version vers = mapping.getVersion();
        if (!this.bufferCustomUpdate(vers, sm, store, customs)) {
            vers.update(sm, store, rowMgr);
        }
        if (versionUpdateOnly) {
            mapping.update(sm, store, rowMgr);
        } else {
            Discriminator dsc = mapping.getDiscriminator();
            if (!this.bufferCustomUpdate(dsc, sm, store, customs)) {
                dsc.update(sm, store, rowMgr);
            }
        }
    }

    private boolean bufferCustomUpdate(Strategy strat, OpenJPAStateManager sm, JDBCStore store, Collection customs) {
        Boolean custom = strat.isCustomUpdate(sm, store);
        if (!Boolean.FALSE.equals(custom)) {
            customs.add(new CustomMapping(1, sm, strat));
        }
        return Boolean.TRUE.equals(custom);
    }

    protected static class CustomMapping {
        public static final int INSERT = 0;
        public static final int UPDATE = 1;
        public static final int DELETE = 3;
        private final int _action;
        private final OpenJPAStateManager _sm;
        private final Strategy _strat;

        public CustomMapping(int action, OpenJPAStateManager sm, Strategy strat) {
            this._action = action;
            this._sm = sm;
            this._strat = strat;
        }

        public void execute(JDBCStore store) throws SQLException {
            switch (this._action) {
                case 0: {
                    this._strat.customInsert(this._sm, store);
                    break;
                }
                case 1: {
                    this._strat.customUpdate(this._sm, store);
                    break;
                }
                case 3: {
                    this._strat.customDelete(this._sm, store);
                }
            }
        }
    }
}

