/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.filter;

import org.apache.xbean.finder.filter.Filter;

public class PackageFilter
implements Filter {
    private final String packageName;

    public PackageFilter(String packageName) {
        assert (packageName != null);
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean accept(String name) {
        return name.startsWith(this.packageName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageFilter that = (PackageFilter)o;
        return this.packageName.equals(that.packageName);
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }

    public String toString() {
        return "PackageFilter{package='" + this.packageName + '\'' + '}';
    }
}

