/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by "stringer -type TagType"; DO NOT EDIT.

package modbus

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[Coil-0]
	_ = x[DiscreteInput-1]
	_ = x[InputRegister-3]
	_ = x[HoldingRegister-4]
	_ = x[ExtendedRegister-6]
}

const (
	_TagType_name_0 = "CoilDiscreteInput"
	_TagType_name_1 = "InputRegisterHoldingRegister"
	_TagType_name_2 = "ExtendedRegister"
)

var (
	_TagType_index_0 = [...]uint8{0, 4, 17}
	_TagType_index_1 = [...]uint8{0, 13, 28}
)

func (i TagType) String() string {
	switch {
	case i <= 1:
		return _TagType_name_0[_TagType_index_0[i]:_TagType_index_0[i+1]]
	case 3 <= i && i <= 4:
		i -= 3
		return _TagType_name_1[_TagType_index_1[i]:_TagType_index_1[i+1]]
	case i == 6:
		return _TagType_name_2
	default:
		return "TagType(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
