/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableConnect is an enum
type OpcuaNodeIdServicesVariableConnect int32

type IOpcuaNodeIdServicesVariableConnect interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_InputArguments  OpcuaNodeIdServicesVariableConnect = 25332
	OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_OutputArguments OpcuaNodeIdServicesVariableConnect = 25333
)

var OpcuaNodeIdServicesVariableConnectValues []OpcuaNodeIdServicesVariableConnect

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableConnectValues = []OpcuaNodeIdServicesVariableConnect{
		OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_InputArguments,
		OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_OutputArguments,
	}
}

func OpcuaNodeIdServicesVariableConnectByValue(value int32) (enum OpcuaNodeIdServicesVariableConnect, ok bool) {
	switch value {
	case 25332:
		return OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_InputArguments, true
	case 25333:
		return OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_OutputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableConnectByName(value string) (enum OpcuaNodeIdServicesVariableConnect, ok bool) {
	switch value {
	case "ConnectSecurityGroupsMethodType_InputArguments":
		return OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_InputArguments, true
	case "ConnectSecurityGroupsMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_OutputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableConnectKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableConnectValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableConnect(structType any) OpcuaNodeIdServicesVariableConnect {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableConnect {
		if sOpcuaNodeIdServicesVariableConnect, ok := typ.(OpcuaNodeIdServicesVariableConnect); ok {
			return sOpcuaNodeIdServicesVariableConnect
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableConnect) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableConnect) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableConnectParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableConnect, error) {
	return OpcuaNodeIdServicesVariableConnectParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableConnectParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableConnect, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableConnect", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableConnect")
	}
	if enum, ok := OpcuaNodeIdServicesVariableConnectByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableConnect")
		return OpcuaNodeIdServicesVariableConnect(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableConnect) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableConnect) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableConnect", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableConnect) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableConnect) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_InputArguments:
		return "ConnectSecurityGroupsMethodType_InputArguments"
	case OpcuaNodeIdServicesVariableConnect_ConnectSecurityGroupsMethodType_OutputArguments:
		return "ConnectSecurityGroupsMethodType_OutputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableConnect) String() string {
	return e.PLC4XEnumName()
}
