/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableFilter is an enum
type OpcuaNodeIdServicesVariableFilter int32

type IOpcuaNodeIdServicesVariableFilter interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableFilter_FilterOperator_EnumStrings OpcuaNodeIdServicesVariableFilter = 7605
)

var OpcuaNodeIdServicesVariableFilterValues []OpcuaNodeIdServicesVariableFilter

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableFilterValues = []OpcuaNodeIdServicesVariableFilter{
		OpcuaNodeIdServicesVariableFilter_FilterOperator_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableFilterByValue(value int32) (enum OpcuaNodeIdServicesVariableFilter, ok bool) {
	switch value {
	case 7605:
		return OpcuaNodeIdServicesVariableFilter_FilterOperator_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableFilterByName(value string) (enum OpcuaNodeIdServicesVariableFilter, ok bool) {
	switch value {
	case "FilterOperator_EnumStrings":
		return OpcuaNodeIdServicesVariableFilter_FilterOperator_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableFilterKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableFilterValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableFilter(structType any) OpcuaNodeIdServicesVariableFilter {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableFilter {
		if sOpcuaNodeIdServicesVariableFilter, ok := typ.(OpcuaNodeIdServicesVariableFilter); ok {
			return sOpcuaNodeIdServicesVariableFilter
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableFilter) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableFilter) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableFilterParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableFilter, error) {
	return OpcuaNodeIdServicesVariableFilterParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableFilterParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableFilter, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableFilter", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableFilter")
	}
	if enum, ok := OpcuaNodeIdServicesVariableFilterByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableFilter")
		return OpcuaNodeIdServicesVariableFilter(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableFilter) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableFilter) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableFilter", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableFilter) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableFilter) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableFilter_FilterOperator_EnumStrings:
		return "FilterOperator_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableFilter) String() string {
	return e.PLC4XEnumName()
}
