/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PubSubKeyPushTargetDataType is the corresponding interface of PubSubKeyPushTargetDataType
type PubSubKeyPushTargetDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetApplicationUri returns ApplicationUri (property field)
	GetApplicationUri() PascalString
	// GetPushTargetFolder returns PushTargetFolder (property field)
	GetPushTargetFolder() []PascalString
	// GetEndpointUrl returns EndpointUrl (property field)
	GetEndpointUrl() PascalString
	// GetSecurityPolicyUri returns SecurityPolicyUri (property field)
	GetSecurityPolicyUri() PascalString
	// GetUserTokenType returns UserTokenType (property field)
	GetUserTokenType() UserTokenPolicy
	// GetRequestedKeyCount returns RequestedKeyCount (property field)
	GetRequestedKeyCount() uint16
	// GetRetryInterval returns RetryInterval (property field)
	GetRetryInterval() float64
	// GetPushTargetProperties returns PushTargetProperties (property field)
	GetPushTargetProperties() []KeyValuePair
	// GetSecurityGroups returns SecurityGroups (property field)
	GetSecurityGroups() []PascalString
	// IsPubSubKeyPushTargetDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPubSubKeyPushTargetDataType()
	// CreateBuilder creates a PubSubKeyPushTargetDataTypeBuilder
	CreatePubSubKeyPushTargetDataTypeBuilder() PubSubKeyPushTargetDataTypeBuilder
}

// _PubSubKeyPushTargetDataType is the data-structure of this message
type _PubSubKeyPushTargetDataType struct {
	ExtensionObjectDefinitionContract
	ApplicationUri       PascalString
	PushTargetFolder     []PascalString
	EndpointUrl          PascalString
	SecurityPolicyUri    PascalString
	UserTokenType        UserTokenPolicy
	RequestedKeyCount    uint16
	RetryInterval        float64
	PushTargetProperties []KeyValuePair
	SecurityGroups       []PascalString
}

var _ PubSubKeyPushTargetDataType = (*_PubSubKeyPushTargetDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PubSubKeyPushTargetDataType)(nil)

// NewPubSubKeyPushTargetDataType factory function for _PubSubKeyPushTargetDataType
func NewPubSubKeyPushTargetDataType(applicationUri PascalString, pushTargetFolder []PascalString, endpointUrl PascalString, securityPolicyUri PascalString, userTokenType UserTokenPolicy, requestedKeyCount uint16, retryInterval float64, pushTargetProperties []KeyValuePair, securityGroups []PascalString) *_PubSubKeyPushTargetDataType {
	if applicationUri == nil {
		panic("applicationUri of type PascalString for PubSubKeyPushTargetDataType must not be nil")
	}
	if endpointUrl == nil {
		panic("endpointUrl of type PascalString for PubSubKeyPushTargetDataType must not be nil")
	}
	if securityPolicyUri == nil {
		panic("securityPolicyUri of type PascalString for PubSubKeyPushTargetDataType must not be nil")
	}
	if userTokenType == nil {
		panic("userTokenType of type UserTokenPolicy for PubSubKeyPushTargetDataType must not be nil")
	}
	_result := &_PubSubKeyPushTargetDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ApplicationUri:                    applicationUri,
		PushTargetFolder:                  pushTargetFolder,
		EndpointUrl:                       endpointUrl,
		SecurityPolicyUri:                 securityPolicyUri,
		UserTokenType:                     userTokenType,
		RequestedKeyCount:                 requestedKeyCount,
		RetryInterval:                     retryInterval,
		PushTargetProperties:              pushTargetProperties,
		SecurityGroups:                    securityGroups,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PubSubKeyPushTargetDataTypeBuilder is a builder for PubSubKeyPushTargetDataType
type PubSubKeyPushTargetDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(applicationUri PascalString, pushTargetFolder []PascalString, endpointUrl PascalString, securityPolicyUri PascalString, userTokenType UserTokenPolicy, requestedKeyCount uint16, retryInterval float64, pushTargetProperties []KeyValuePair, securityGroups []PascalString) PubSubKeyPushTargetDataTypeBuilder
	// WithApplicationUri adds ApplicationUri (property field)
	WithApplicationUri(PascalString) PubSubKeyPushTargetDataTypeBuilder
	// WithApplicationUriBuilder adds ApplicationUri (property field) which is build by the builder
	WithApplicationUriBuilder(func(PascalStringBuilder) PascalStringBuilder) PubSubKeyPushTargetDataTypeBuilder
	// WithPushTargetFolder adds PushTargetFolder (property field)
	WithPushTargetFolder(...PascalString) PubSubKeyPushTargetDataTypeBuilder
	// WithEndpointUrl adds EndpointUrl (property field)
	WithEndpointUrl(PascalString) PubSubKeyPushTargetDataTypeBuilder
	// WithEndpointUrlBuilder adds EndpointUrl (property field) which is build by the builder
	WithEndpointUrlBuilder(func(PascalStringBuilder) PascalStringBuilder) PubSubKeyPushTargetDataTypeBuilder
	// WithSecurityPolicyUri adds SecurityPolicyUri (property field)
	WithSecurityPolicyUri(PascalString) PubSubKeyPushTargetDataTypeBuilder
	// WithSecurityPolicyUriBuilder adds SecurityPolicyUri (property field) which is build by the builder
	WithSecurityPolicyUriBuilder(func(PascalStringBuilder) PascalStringBuilder) PubSubKeyPushTargetDataTypeBuilder
	// WithUserTokenType adds UserTokenType (property field)
	WithUserTokenType(UserTokenPolicy) PubSubKeyPushTargetDataTypeBuilder
	// WithUserTokenTypeBuilder adds UserTokenType (property field) which is build by the builder
	WithUserTokenTypeBuilder(func(UserTokenPolicyBuilder) UserTokenPolicyBuilder) PubSubKeyPushTargetDataTypeBuilder
	// WithRequestedKeyCount adds RequestedKeyCount (property field)
	WithRequestedKeyCount(uint16) PubSubKeyPushTargetDataTypeBuilder
	// WithRetryInterval adds RetryInterval (property field)
	WithRetryInterval(float64) PubSubKeyPushTargetDataTypeBuilder
	// WithPushTargetProperties adds PushTargetProperties (property field)
	WithPushTargetProperties(...KeyValuePair) PubSubKeyPushTargetDataTypeBuilder
	// WithSecurityGroups adds SecurityGroups (property field)
	WithSecurityGroups(...PascalString) PubSubKeyPushTargetDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PubSubKeyPushTargetDataType or returns an error if something is wrong
	Build() (PubSubKeyPushTargetDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PubSubKeyPushTargetDataType
}

// NewPubSubKeyPushTargetDataTypeBuilder() creates a PubSubKeyPushTargetDataTypeBuilder
func NewPubSubKeyPushTargetDataTypeBuilder() PubSubKeyPushTargetDataTypeBuilder {
	return &_PubSubKeyPushTargetDataTypeBuilder{_PubSubKeyPushTargetDataType: new(_PubSubKeyPushTargetDataType)}
}

type _PubSubKeyPushTargetDataTypeBuilder struct {
	*_PubSubKeyPushTargetDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (PubSubKeyPushTargetDataTypeBuilder) = (*_PubSubKeyPushTargetDataTypeBuilder)(nil)

func (b *_PubSubKeyPushTargetDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PubSubKeyPushTargetDataType
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithMandatoryFields(applicationUri PascalString, pushTargetFolder []PascalString, endpointUrl PascalString, securityPolicyUri PascalString, userTokenType UserTokenPolicy, requestedKeyCount uint16, retryInterval float64, pushTargetProperties []KeyValuePair, securityGroups []PascalString) PubSubKeyPushTargetDataTypeBuilder {
	return b.WithApplicationUri(applicationUri).WithPushTargetFolder(pushTargetFolder...).WithEndpointUrl(endpointUrl).WithSecurityPolicyUri(securityPolicyUri).WithUserTokenType(userTokenType).WithRequestedKeyCount(requestedKeyCount).WithRetryInterval(retryInterval).WithPushTargetProperties(pushTargetProperties...).WithSecurityGroups(securityGroups...)
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithApplicationUri(applicationUri PascalString) PubSubKeyPushTargetDataTypeBuilder {
	b.ApplicationUri = applicationUri
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithApplicationUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PubSubKeyPushTargetDataTypeBuilder {
	builder := builderSupplier(b.ApplicationUri.CreatePascalStringBuilder())
	var err error
	b.ApplicationUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithPushTargetFolder(pushTargetFolder ...PascalString) PubSubKeyPushTargetDataTypeBuilder {
	b.PushTargetFolder = pushTargetFolder
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithEndpointUrl(endpointUrl PascalString) PubSubKeyPushTargetDataTypeBuilder {
	b.EndpointUrl = endpointUrl
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithEndpointUrlBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PubSubKeyPushTargetDataTypeBuilder {
	builder := builderSupplier(b.EndpointUrl.CreatePascalStringBuilder())
	var err error
	b.EndpointUrl, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithSecurityPolicyUri(securityPolicyUri PascalString) PubSubKeyPushTargetDataTypeBuilder {
	b.SecurityPolicyUri = securityPolicyUri
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithSecurityPolicyUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PubSubKeyPushTargetDataTypeBuilder {
	builder := builderSupplier(b.SecurityPolicyUri.CreatePascalStringBuilder())
	var err error
	b.SecurityPolicyUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithUserTokenType(userTokenType UserTokenPolicy) PubSubKeyPushTargetDataTypeBuilder {
	b.UserTokenType = userTokenType
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithUserTokenTypeBuilder(builderSupplier func(UserTokenPolicyBuilder) UserTokenPolicyBuilder) PubSubKeyPushTargetDataTypeBuilder {
	builder := builderSupplier(b.UserTokenType.CreateUserTokenPolicyBuilder())
	var err error
	b.UserTokenType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "UserTokenPolicyBuilder failed"))
	}
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithRequestedKeyCount(requestedKeyCount uint16) PubSubKeyPushTargetDataTypeBuilder {
	b.RequestedKeyCount = requestedKeyCount
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithRetryInterval(retryInterval float64) PubSubKeyPushTargetDataTypeBuilder {
	b.RetryInterval = retryInterval
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithPushTargetProperties(pushTargetProperties ...KeyValuePair) PubSubKeyPushTargetDataTypeBuilder {
	b.PushTargetProperties = pushTargetProperties
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) WithSecurityGroups(securityGroups ...PascalString) PubSubKeyPushTargetDataTypeBuilder {
	b.SecurityGroups = securityGroups
	return b
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) Build() (PubSubKeyPushTargetDataType, error) {
	if b.ApplicationUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'applicationUri' not set"))
	}
	if b.EndpointUrl == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'endpointUrl' not set"))
	}
	if b.SecurityPolicyUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'securityPolicyUri' not set"))
	}
	if b.UserTokenType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'userTokenType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._PubSubKeyPushTargetDataType.deepCopy(), nil
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) MustBuild() PubSubKeyPushTargetDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PubSubKeyPushTargetDataTypeBuilder) DeepCopy() any {
	_copy := b.CreatePubSubKeyPushTargetDataTypeBuilder().(*_PubSubKeyPushTargetDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreatePubSubKeyPushTargetDataTypeBuilder creates a PubSubKeyPushTargetDataTypeBuilder
func (b *_PubSubKeyPushTargetDataType) CreatePubSubKeyPushTargetDataTypeBuilder() PubSubKeyPushTargetDataTypeBuilder {
	if b == nil {
		return NewPubSubKeyPushTargetDataTypeBuilder()
	}
	return &_PubSubKeyPushTargetDataTypeBuilder{_PubSubKeyPushTargetDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PubSubKeyPushTargetDataType) GetExtensionId() int32 {
	return int32(25272)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PubSubKeyPushTargetDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PubSubKeyPushTargetDataType) GetApplicationUri() PascalString {
	return m.ApplicationUri
}

func (m *_PubSubKeyPushTargetDataType) GetPushTargetFolder() []PascalString {
	return m.PushTargetFolder
}

func (m *_PubSubKeyPushTargetDataType) GetEndpointUrl() PascalString {
	return m.EndpointUrl
}

func (m *_PubSubKeyPushTargetDataType) GetSecurityPolicyUri() PascalString {
	return m.SecurityPolicyUri
}

func (m *_PubSubKeyPushTargetDataType) GetUserTokenType() UserTokenPolicy {
	return m.UserTokenType
}

func (m *_PubSubKeyPushTargetDataType) GetRequestedKeyCount() uint16 {
	return m.RequestedKeyCount
}

func (m *_PubSubKeyPushTargetDataType) GetRetryInterval() float64 {
	return m.RetryInterval
}

func (m *_PubSubKeyPushTargetDataType) GetPushTargetProperties() []KeyValuePair {
	return m.PushTargetProperties
}

func (m *_PubSubKeyPushTargetDataType) GetSecurityGroups() []PascalString {
	return m.SecurityGroups
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPubSubKeyPushTargetDataType(structType any) PubSubKeyPushTargetDataType {
	if casted, ok := structType.(PubSubKeyPushTargetDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PubSubKeyPushTargetDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PubSubKeyPushTargetDataType) GetTypeName() string {
	return "PubSubKeyPushTargetDataType"
}

func (m *_PubSubKeyPushTargetDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (applicationUri)
	lengthInBits += m.ApplicationUri.GetLengthInBits(ctx)

	// Implicit Field (noOfPushTargetFolder)
	lengthInBits += 32

	// Array field
	if len(m.PushTargetFolder) > 0 {
		for _curItem, element := range m.PushTargetFolder {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.PushTargetFolder), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (endpointUrl)
	lengthInBits += m.EndpointUrl.GetLengthInBits(ctx)

	// Simple field (securityPolicyUri)
	lengthInBits += m.SecurityPolicyUri.GetLengthInBits(ctx)

	// Simple field (userTokenType)
	lengthInBits += m.UserTokenType.GetLengthInBits(ctx)

	// Simple field (requestedKeyCount)
	lengthInBits += 16

	// Simple field (retryInterval)
	lengthInBits += 64

	// Implicit Field (noOfPushTargetProperties)
	lengthInBits += 32

	// Array field
	if len(m.PushTargetProperties) > 0 {
		for _curItem, element := range m.PushTargetProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.PushTargetProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfSecurityGroups)
	lengthInBits += 32

	// Array field
	if len(m.SecurityGroups) > 0 {
		for _curItem, element := range m.SecurityGroups {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SecurityGroups), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PubSubKeyPushTargetDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PubSubKeyPushTargetDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__pubSubKeyPushTargetDataType PubSubKeyPushTargetDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PubSubKeyPushTargetDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PubSubKeyPushTargetDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	applicationUri, err := ReadSimpleField[PascalString](ctx, "applicationUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'applicationUri' field"))
	}
	m.ApplicationUri = applicationUri

	noOfPushTargetFolder, err := ReadImplicitField[int32](ctx, "noOfPushTargetFolder", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfPushTargetFolder' field"))
	}
	_ = noOfPushTargetFolder

	pushTargetFolder, err := ReadCountArrayField[PascalString](ctx, "pushTargetFolder", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfPushTargetFolder))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'pushTargetFolder' field"))
	}
	m.PushTargetFolder = pushTargetFolder

	endpointUrl, err := ReadSimpleField[PascalString](ctx, "endpointUrl", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'endpointUrl' field"))
	}
	m.EndpointUrl = endpointUrl

	securityPolicyUri, err := ReadSimpleField[PascalString](ctx, "securityPolicyUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityPolicyUri' field"))
	}
	m.SecurityPolicyUri = securityPolicyUri

	userTokenType, err := ReadSimpleField[UserTokenPolicy](ctx, "userTokenType", ReadComplex[UserTokenPolicy](ExtensionObjectDefinitionParseWithBufferProducer[UserTokenPolicy]((int32)(int32(306))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userTokenType' field"))
	}
	m.UserTokenType = userTokenType

	requestedKeyCount, err := ReadSimpleField(ctx, "requestedKeyCount", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestedKeyCount' field"))
	}
	m.RequestedKeyCount = requestedKeyCount

	retryInterval, err := ReadSimpleField(ctx, "retryInterval", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'retryInterval' field"))
	}
	m.RetryInterval = retryInterval

	noOfPushTargetProperties, err := ReadImplicitField[int32](ctx, "noOfPushTargetProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfPushTargetProperties' field"))
	}
	_ = noOfPushTargetProperties

	pushTargetProperties, err := ReadCountArrayField[KeyValuePair](ctx, "pushTargetProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfPushTargetProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'pushTargetProperties' field"))
	}
	m.PushTargetProperties = pushTargetProperties

	noOfSecurityGroups, err := ReadImplicitField[int32](ctx, "noOfSecurityGroups", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfSecurityGroups' field"))
	}
	_ = noOfSecurityGroups

	securityGroups, err := ReadCountArrayField[PascalString](ctx, "securityGroups", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfSecurityGroups))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityGroups' field"))
	}
	m.SecurityGroups = securityGroups

	if closeErr := readBuffer.CloseContext("PubSubKeyPushTargetDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PubSubKeyPushTargetDataType")
	}

	return m, nil
}

func (m *_PubSubKeyPushTargetDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PubSubKeyPushTargetDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PubSubKeyPushTargetDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PubSubKeyPushTargetDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "applicationUri", m.GetApplicationUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'applicationUri' field")
		}
		noOfPushTargetFolder := int32(utils.InlineIf(bool((m.GetPushTargetFolder()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetPushTargetFolder()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfPushTargetFolder", noOfPushTargetFolder, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfPushTargetFolder' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "pushTargetFolder", m.GetPushTargetFolder(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'pushTargetFolder' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "endpointUrl", m.GetEndpointUrl(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'endpointUrl' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "securityPolicyUri", m.GetSecurityPolicyUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'securityPolicyUri' field")
		}

		if err := WriteSimpleField[UserTokenPolicy](ctx, "userTokenType", m.GetUserTokenType(), WriteComplex[UserTokenPolicy](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'userTokenType' field")
		}

		if err := WriteSimpleField[uint16](ctx, "requestedKeyCount", m.GetRequestedKeyCount(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestedKeyCount' field")
		}

		if err := WriteSimpleField[float64](ctx, "retryInterval", m.GetRetryInterval(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'retryInterval' field")
		}
		noOfPushTargetProperties := int32(utils.InlineIf(bool((m.GetPushTargetProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetPushTargetProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfPushTargetProperties", noOfPushTargetProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfPushTargetProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "pushTargetProperties", m.GetPushTargetProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'pushTargetProperties' field")
		}
		noOfSecurityGroups := int32(utils.InlineIf(bool((m.GetSecurityGroups()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetSecurityGroups()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfSecurityGroups", noOfSecurityGroups, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfSecurityGroups' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "securityGroups", m.GetSecurityGroups(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'securityGroups' field")
		}

		if popErr := writeBuffer.PopContext("PubSubKeyPushTargetDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PubSubKeyPushTargetDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PubSubKeyPushTargetDataType) IsPubSubKeyPushTargetDataType() {}

func (m *_PubSubKeyPushTargetDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PubSubKeyPushTargetDataType) deepCopy() *_PubSubKeyPushTargetDataType {
	if m == nil {
		return nil
	}
	_PubSubKeyPushTargetDataTypeCopy := &_PubSubKeyPushTargetDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.ApplicationUri),
		utils.DeepCopySlice[PascalString, PascalString](m.PushTargetFolder),
		utils.DeepCopy[PascalString](m.EndpointUrl),
		utils.DeepCopy[PascalString](m.SecurityPolicyUri),
		utils.DeepCopy[UserTokenPolicy](m.UserTokenType),
		m.RequestedKeyCount,
		m.RetryInterval,
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.PushTargetProperties),
		utils.DeepCopySlice[PascalString, PascalString](m.SecurityGroups),
	}
	_PubSubKeyPushTargetDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PubSubKeyPushTargetDataTypeCopy
}

func (m *_PubSubKeyPushTargetDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
