/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HistoryData extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 658;
  }

  // Properties.
  protected final List<DataValue> dataValues;

  public HistoryData(List<DataValue> dataValues) {
    super();
    this.dataValues = dataValues;
  }

  public List<DataValue> getDataValues() {
    return dataValues;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HistoryData");

    // Implicit Field (noOfDataValues) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDataValues = (int) ((((getDataValues()) == (null)) ? -(1) : COUNT(getDataValues())));
    writeImplicitField("noOfDataValues", noOfDataValues, writeSignedInt(writeBuffer, 32));

    // Array Field (dataValues)
    writeComplexTypeArrayField("dataValues", dataValues, writeBuffer);

    writeBuffer.popContext("HistoryData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    HistoryData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (noOfDataValues)
    lengthInBits += 32;

    // Array field
    if (dataValues != null) {
      int i = 0;
      for (DataValue element : dataValues) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataValues.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("HistoryData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int noOfDataValues = readImplicitField("noOfDataValues", readSignedInt(readBuffer, 32));

    List<DataValue> dataValues =
        readCountArrayField(
            "dataValues",
            readComplex(() -> DataValue.staticParse(readBuffer), readBuffer),
            noOfDataValues);

    readBuffer.closeContext("HistoryData");
    // Create the instance
    return new HistoryDataBuilderImpl(dataValues);
  }

  public static class HistoryDataBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final List<DataValue> dataValues;

    public HistoryDataBuilderImpl(List<DataValue> dataValues) {
      this.dataValues = dataValues;
    }

    public HistoryData build() {
      HistoryData historyData = new HistoryData(dataValues);
      return historyData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HistoryData)) {
      return false;
    }
    HistoryData that = (HistoryData) o;
    return (getDataValues() == that.getDataValues()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDataValues());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
