# PIP-435: Add `startTimestamp` and `endTimestamp` for consuming messages in client cli

# Background knowledge

Currently, if users consume messages from a topic using the Pulsar client CLI, they can't have an option to consume messages from a specific time. This PIP proposes to add `startTimestamp` and `endTimestamp` options to the Pulsar client CLI to allow users to consume messages within a specific time range.

# Motivation

Add `startTimestamp` and `endTimestamp` options to the client consume CLI.

# Goals

## In Scope


## Out of Scope

# High Level Design

Add `startTimestamp` and `endTimestamp` options in CmdConsume.

```bash
@Option(names = { "-stp", "--start-timestamp" }, description = "Start timestamp for consuming messages")
private long startTimestamp = 0L;

@Option(names = { "-etp", "--end-timestamp" }, description = "End timestamp for consuming messages")
private long endTimestamp = Long.MAX_VALUE;
```

Then use `consumer.seek(startTimestamp)` to consume the messages from the specified start timestamp, and check the `publishTime` of the received msg, if larger than the `endTimestamp`, stop the consume process.

# Backward & Forward Compatibility


# Alternatives


# Links

* Mailing List discussion thread: https://lists.apache.org/thread/4xl3goqozrq6bogm0rysytcmfxqbsnwl
* Mailing List voting thread: https://lists.apache.org/thread/v1rpb8o0wbc6y4njnsh8c00j9dxcpv9d
