/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.ratis.server.raftlog.segmented.LogSegmentStartEnd;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogSegmentPath {
    static final Logger LOG = LoggerFactory.getLogger(LogSegmentPath.class);
    private static final Comparator<LogSegmentPath> COMPARATOR = Comparator.comparing(LogSegmentPath::getStartEnd);
    private final Path path;
    private final LogSegmentStartEnd startEnd;

    private LogSegmentPath(Path path, long startIndex, Long endIndex) {
        this.path = path;
        this.startEnd = LogSegmentStartEnd.valueOf(startIndex, endIndex);
    }

    public Path getPath() {
        return this.path;
    }

    public LogSegmentStartEnd getStartEnd() {
        return this.startEnd;
    }

    public String toString() {
        return this.path + "(" + this.startEnd + ")";
    }

    public static List<LogSegmentPath> getLogSegmentPaths(RaftStorage storage) throws IOException {
        return LogSegmentPath.getLogSegmentPaths(storage.getStorageDir().getCurrentDir().toPath());
    }

    private static List<LogSegmentPath> getLogSegmentPaths(Path dir) throws IOException {
        ArrayList<LogSegmentPath> list = new ArrayList<LogSegmentPath>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                Optional.ofNullable(LogSegmentPath.matchLogSegment(path)).ifPresent(list::add);
            }
        }
        list.sort(COMPARATOR);
        return list;
    }

    public static LogSegmentPath matchLogSegment(Path path) {
        return Optional.ofNullable(LogSegmentPath.matchCloseSegment(path)).orElseGet(() -> LogSegmentPath.matchOpenSegment(path));
    }

    private static LogSegmentPath matchCloseSegment(Path path) {
        String fileName = String.valueOf(Objects.requireNonNull(path).getFileName());
        Matcher matcher = LogSegmentStartEnd.getClosedSegmentPattern().matcher(fileName);
        if (matcher.matches()) {
            Preconditions.assertTrue(matcher.groupCount() == 2);
            return LogSegmentPath.newInstance(path, matcher.group(1), matcher.group(2));
        }
        return null;
    }

    private static LogSegmentPath matchOpenSegment(Path path) {
        String fileName = String.valueOf(Objects.requireNonNull(path).getFileName());
        Matcher matcher = LogSegmentStartEnd.getOpenSegmentPattern().matcher(fileName);
        if (matcher.matches()) {
            if (path.toFile().length() > 0L) {
                return LogSegmentPath.newInstance(path, matcher.group(1), null);
            }
            LOG.info("Found zero size open segment file " + path);
            try {
                Files.delete(path);
                LOG.info("Deleted zero size open segment file " + path);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete zero size open segment file " + path + ": " + e);
            }
        }
        return null;
    }

    private static LogSegmentPath newInstance(Path path, String startIndexString, String endIndexString) {
        long startIndex = Long.parseLong(startIndexString);
        Long endIndex = Optional.ofNullable(endIndexString).map(Long::parseLong).orElse(null);
        return new LogSegmentPath(path, startIndex, endIndex);
    }
}

