/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.ch.qos.logback.classic.spi;

import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.Level;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.Logger;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.turbo.TurboFilter;
import org.apache.rocketmq.shaded.ch.qos.logback.core.spi.FilterReply;
import org.apache.rocketmq.shaded.org.slf4j.Marker;

public final class TurboFilterList
extends CopyOnWriteArrayList<TurboFilter> {
    private static final long serialVersionUID = 1L;

    public FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        int size = this.size();
        if (size == 1) {
            try {
                TurboFilter tf = (TurboFilter)this.get(0);
                return tf.decide(marker, logger, level, format, params, t);
            }
            catch (IndexOutOfBoundsException iobe) {
                return FilterReply.NEUTRAL;
            }
        }
        Object[] tfa = this.toArray();
        int len = tfa.length;
        for (int i = 0; i < len; ++i) {
            TurboFilter tf = (TurboFilter)tfa[i];
            FilterReply r = tf.decide(marker, logger, level, format, params, t);
            if (r != FilterReply.DENY && r != FilterReply.ACCEPT) continue;
            return r;
        }
        return FilterReply.NEUTRAL;
    }
}

