/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state;

import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.View;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.DefaultSynchronousMetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;

public interface SynchronousMetricStorage
extends MetricStorage,
WriteableMetricStorage {
    public static SynchronousMetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    public static <T, U extends ExemplarData> SynchronousMetricStorage create(RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, exemplarFilter);
        if (Aggregator.drop() == aggregator) {
            return SynchronousMetricStorage.empty();
        }
        return new DefaultSynchronousMetricStorage(metricDescriptor, aggregator, registeredView.getViewAttributesProcessor());
    }
}

