/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.rocketmq.shaded.com.google.common.io.ByteStreams;
import org.apache.rocketmq.shaded.io.grpc.Drainable;
import org.apache.rocketmq.shaded.io.grpc.KnownLength;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;

public final class MarshalerInputStream
extends InputStream
implements Drainable,
KnownLength {
    @Nullable
    private Marshaler message;
    @Nullable
    private ByteArrayInputStream partial;

    public MarshalerInputStream(Marshaler message) {
        this.message = message;
    }

    @Override
    public int drainTo(OutputStream target) throws IOException {
        int written;
        if (this.message != null) {
            written = this.message.getBinarySerializedSize();
            this.message.writeBinaryTo(target);
            this.message = null;
        } else if (this.partial != null) {
            written = (int)ByteStreams.copy(this.partial, target);
            this.partial = null;
        } else {
            written = 0;
        }
        return written;
    }

    @Override
    public int read() throws IOException {
        if (this.message != null) {
            this.partial = new ByteArrayInputStream(MarshalerInputStream.toByteArray(this.message));
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.message != null) {
            int size = this.message.getBinarySerializedSize();
            if (size == 0) {
                this.message = null;
                this.partial = null;
                return -1;
            }
            this.partial = new ByteArrayInputStream(MarshalerInputStream.toByteArray(this.message));
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read(b, off, len);
        }
        return -1;
    }

    private static byte[] toByteArray(Marshaler message) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(message.getBinarySerializedSize());
        message.writeBinaryTo(bos);
        return bos.toByteArray();
    }

    @Override
    public int available() {
        if (this.message != null) {
            return this.message.getBinarySerializedSize();
        }
        if (this.partial != null) {
            return this.partial.available();
        }
        return 0;
    }
}

