/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.xml.security.parser;

import java.io.InputStream;

import org.w3c.dom.Document;

/**
 * A interface to allow pluggable ways of parsing an InputStream into a DOM Document.
 */
public interface XMLParser {

    /**
     * Parses a document from the input stream.
     * Caller is responsible for closing the stream.
     *
     * @param inputStream
     * @param disallowDocTypeDeclarations
     * @return {@link Document}
     * @throws XMLParserException
     */
    Document parse(InputStream inputStream, boolean disallowDocTypeDeclarations) throws XMLParserException;

}